#ifndef _KCOMBOBOX_H_
#define _KCOMBOBOX_H_

#include <Python.h>
#include <kcombo.h>
#include "../qt/Baseobject.h"


class _ComboBox : public KCombo, public BaseObject
{
  Q_OBJECT	

  public:

  _ComboBox(QWidget *parent=0, const char *name=0, WFlags f=0) : KCombo(parent,name,f), BaseObject() {
    connect(this, SIGNAL(activated(int)), this, SLOT(sigActivated(int)));
    connect(this, SIGNAL(highlighted(int)), this, SLOT(sigHighlighted(int)));
  }
  _ComboBox(bool readWrite, QWidget *parent=0, const char *name=0, WFlags f=0) : KCombo(readWrite,parent,name,f), BaseObject() {
    connect(this, SIGNAL(activated(int)), this, SLOT(sigActivated(int)));
    connect(this, SIGNAL(highlighted(int)), this, SLOT(sigHighlighted(int)));
  }
  ~_ComboBox() {};


  public slots:
  
    void sigActivated(int index) {
      PyObject *arg = Py_BuildValue("(i)",index);
      _emit("activated", arg);
      Py_DECREF(arg);
    };

    void sigHighlighted(int index) {
      PyObject *arg = Py_BuildValue("(i)",index);
      _emit("highlighted", arg);
      Py_DECREF(arg);
    };    
  
};

#endif
