/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLHELPER_H
#define KLHELPER_H
#include "klchild.h"

/**
* This header containts some functions, which
* helps you to create a "more readable" 
* layoutcreationtree
*
* This are all global functions
*/

/**
* Group functions
*
* All of this functions have a ppgroup pointer.
* If you give a pointer to a pointer of the specific
* group, it will be filled with the address of the group
* 
* (To avoid ugly things like:
* <pre>
* KLHVGroup *mygroup;
* (*(mygroup = &klHGroup())
* </pre>
*
* So you can now write:
* <pre>
* KLHVGroup *mygroup;
* (klHGroup(&mygroup)
* </pre>
*/
class KLHVGroup;
KLHVGroup &klHGroup(KLHVGroup **ppgroup = 0);
KLHVGroup &klVGroup(KLHVGroup **ppgroup = 0);
class KLGridGroup;
KLGridGroup &klGridGroup(ulong rowColCount = 2, bool rowGrid = false,KLGridGroup **ppgroup = 0);
class KLGroupBox;
KLGroupBox &klGroupBox(const char *title,bool horiz,KLGroupBox **ppgroup = 0);


// Common Widgets
class KLLabel;
KLLabel *klLabel(const char *text);
class KLButton;
KLButton *klButton(const char *text);
class KLCheckBox;
KLCheckBox *klCheckBox(const char *text);
class KLLineEdit;
KLLineEdit *klLineEdit(const char *_default=0);
class KLHVSpace;
KLHVSpace *klHVSpace();
class KLListBox;
KLListBox *klListBox();

/**
* Registration helper
*
* Registers all common KLE-Clases
*/
class KLMetaRegList;
void klRegisterCommonClasses(KLMetaRegList *);

#endif 

