/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLEDIT_H
#define KLEDIT_H

#include "klwidgetbase.h"
#include "qlined.h"
#include "qmlined.h"

/**
* Edit object
*
* Note: It has initialy a weight of 1. 
*/
class KLLineEdit : public QLineEdit, public KLWidgetBase {
  Q_OBJECT
public:
  KLLineEdit(const char *defaulttext=0);
  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);
  DECLARE_KLMETA_STANDALONE_SIMPLE();

  KLWDIGET_DELEGATES(KLLineEdit,QLineEdit);
};

/**
* Multiline Edit object
*
* Note: It has initialy a weight of 1. 
*/
class KLMultiLineEdit : public QMultiLineEdit, public KLWidgetBase {
  Q_OBJECT
public:
  KLMultiLineEdit(const char *defaulttext=0);
  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);
  DECLARE_KLMETA_STANDALONE_SIMPLE();

  KLWDIGET_DELEGATES(KLMultiLineEdit,QMultiLineEdit);
};

#endif 



