/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLDIALOG_H
#define KLDIALOG_H

#include "kldevice.h"
#include <qdialog.h>

/**
* Dialog window for use with KLE.
*
* Will also feature a default button in future
*/
class KLDialog : public QDialog, public KLDevice {
  Q_OBJECT
public:
  KLDialog(bool modal = false,WFlags falgs = 0);

  void show();
  void hide();

  void setDeviceSize(unsigned long xSize, unsigned long ySize);
  bool refreshDisplay();

  virtual class QWidget *getDeviceHandle() 
  { return this; };

  virtual void resizeEvent(QResizeEvent*);

  KLDEVICE_EVENT_CATCH(QDialog);

protected:
  virtual bool createWindow();
  virtual bool showWindow( KLDeviceShowinfo *deviceShowInfo );
  virtual void setLimits( KLDeviceShowinfo *deviceShowInfo );
  virtual void hideWindow();
  virtual void deleteWindow();

  virtual ulong getLeftBorder() const { return 0; };
  virtual ulong getRightBorder() const { return 0; };
  virtual ulong getTopBorder() const { return 0; };
  virtual ulong getBottomBorder() const { return 0; };
};

#endif 

