
#include "mainwin.h"
#include "klcombobox.h"
#include "kprocess.h"

KMainWinApp::KMainWinApp(int argc, char **argv) : KApplication(argc,argv)
{
  // Setup Layout
  KLButton *swbut;
  KLButton *cwbut;
  KLButton *pwbut;
  KLButton *pw2but;
  KLGroup &group = (*(new KLHVGroup(false))
                   << (*(new KLHVGroup(true))
                     << new KLHVSpace()
                     << (*(new KLGroupBox("Description",true))
                        << new KLLabel("","info.xpm",KLLabel::Image)
                        << (desc = new KLLabel()))
                     << new KLHVSpace())
                   << (*(new KLTabGroup())
                      << "SimpleWin"
                      << (*(new KLGroupBox("What does this example show ?",true))
                        << (swbut = new KLButton("","simplewin.xpm",KLButton::Image))
                        << (simplewindesc = new KLLabel()))
                      << "ChangeWin"
                      << (*(new KLGroupBox("What does this example show ?",true))
                        << (cwbut = new KLButton("","changewin.xpm",KLButton::Image))
                        << (changewindesc = new KLLabel()))
                      << "PagingWin"
                      << (*(new KLGroupBox("What does this example show ?",true))
                        << (*(new KLHVGroup(false))
                          << (pwbut = new KLButton("","pagingwin.xpm",KLButton::Image))
                          << (pw2but = new KLButton("","pagingwin2.xpm",KLButton::Image)))
                        << (pagingwindesc = new KLLabel()))));
  win.setRootChild(&group);

  desc->setText("This is the main demonstration\nprogram for the new KDE Layout\nEngine (KLE)."
                "The tabs above just\nshows the other demonstration\nprograms. You can"
                "directly start\nthem with clicking on the images.");
  simplewindesc->setText("This was the first program using the KLE.\nIt`s only a test program\n"
                         "wich provides no nice looking GUI\n -- Its just a test for the layout\nengine.");
  changewindesc->setText("This small demo shows, that it is very\n"
                         "easy to add/remove parts of a GUI at\n"
                         "runtime. It also demonstrates the hidden-\nflag.");
  pagingwindesc->setText("This demonstration progamm just shows pages,\nand two ways to switch between\n"
                         "pages:\n- Using a tabcontrol\n- Using a other kind of widget (e.g. radiobuttons)\n"
                         "\nIt also shows the use of the KRadioManager\nand KLGridGroup(). \n\nLast, but not least, it shows that\n"
                         "it is not only posible to make so \nheavy looking demo GUI's. It also\n"
                         "shows that it is easily possible to\nmake nice GUI's (Button Nice)\n");

  // Setup Menu 
  KMenuBar *menu = win.menuBar();
  QPopupMenu *popup = new QPopupMenu();
  popup->insertItem("&Quit",this,SLOT(quit()));
  menu->insertItem("&File",popup);

  popup = new QPopupMenu();
  popup->insertItem("&SimpleWin",this,SLOT(startSimpleWin()));
  popup->insertItem("&ChangeWin",this,SLOT(startChangeWin()));
  popup->insertItem("&PagingWin",this,SLOT(startPagingWin()));
  menu->insertItem("&Examples",popup);
  menu->insertSeparator();
  menu->insertItem("&Help");

  connect(swbut,SIGNAL(clicked()),this,SLOT(startSimpleWin()));
  connect(cwbut,SIGNAL(clicked()),this,SLOT(startChangeWin()));
  connect(pwbut,SIGNAL(clicked()),this,SLOT(startPagingWin()));
  connect(pw2but,SIGNAL(clicked()),this,SLOT(startPagingWin()));
  win.show();

  setMainWidget(&win);
}

void KMainWinApp::startSimpleWin()
{
  KProcess process;
  process << "simplewin";
  process.start(KProcess::DontCare);
}

void KMainWinApp::startChangeWin()
{
  KProcess process;
  process << "changewin";
  process.start(KProcess::DontCare);
}

void KMainWinApp::startPagingWin()
{
  KProcess process;
  process << "pagingwin";
  process.start(KProcess::DontCare);
}

void KMainWinApp::closeEvent( QCloseEvent *e )
{
  e->ignore();                            
  quit();
}

int main( int argc, char **argv ) 
{
  KMainWinApp app(argc,argv);
  app.exec();
}

#include "mainwin.moc"
