/* minefield.c generated by valac 0.24.0, the Vala compiler
 * generated from minefield.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _LocationPrivate LocationPrivate;
typedef struct _ParamSpecLocation ParamSpecLocation;

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
typedef struct _MinefieldPrivate MinefieldPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _location_unref0(var) ((var == NULL) ? NULL : (var = (location_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecMinefield ParamSpecMinefield;

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Location {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LocationPrivate * priv;
	gboolean has_mine;
	gboolean cleared;
	FlagType flag;
};

struct _LocationClass {
	GTypeClass parent_class;
	void (*finalize) (Location *self);
};

struct _ParamSpecLocation {
	GParamSpec parent_instance;
};

struct _Neighbour {
	gint x;
	gint y;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

struct _MinefieldPrivate {
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean placed_mines;
	guint _n_cleared;
	guint _n_flags;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	guint hint_time_penalty_seconds;
	gboolean _paused;
};

struct _ParamSpecMinefield {
	GParamSpec parent_instance;
};


static gpointer location_parent_class = NULL;
static gpointer minefield_parent_class = NULL;

GType flag_type_get_type (void) G_GNUC_CONST;
gpointer location_ref (gpointer instance);
void location_unref (gpointer instance);
GParamSpec* param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_location (GValue* value, gpointer v_object);
void value_take_location (GValue* value, gpointer v_object);
gpointer value_get_location (const GValue* value);
GType location_get_type (void) G_GNUC_CONST;
enum  {
	LOCATION_DUMMY_PROPERTY
};
Location* location_new (void);
Location* location_construct (GType object_type);
static void location_finalize (Location* obj);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD, MinefieldPrivate))
enum  {
	MINEFIELD_DUMMY_PROPERTY
};
#define MINEFIELD_HINT_TIME_PENALTY_MAX ((guint) 90)
#define MINEFIELD_HINT_TIME_PENALTY_INCREASE ((guint) 10)
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
gboolean minefield_is_clock_started (Minefield* self);
gdouble minefield_get_elapsed (Minefield* self);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static void minefield_start_clock (Minefield* self);
static void minefield_place_mines (Minefield* self, guint x, guint y);
static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y);
static void minefield_stop_clock (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
guint minefield_get_n_cleared (Minefield* self);
void minefield_set_n_cleared (Minefield* self, guint value);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_n_flags (Minefield* self, guint value);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
void minefield_hint (Minefield* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
static gboolean minefield_timeout_cb (Minefield* self);
static void minefield_continue_clock (Minefield* self);
static gboolean _minefield_timeout_cb_gsource_func (gpointer self);
gboolean minefield_get_paused (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void minefield_finalize (Minefield* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const Neighbour neighbour_map[8] = {{-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}};

GType flag_type_get_type (void) {
	static volatile gsize flag_type_type_id__volatile = 0;
	if (g_once_init_enter (&flag_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FLAG_TYPE_NONE, "FLAG_TYPE_NONE", "none"}, {FLAG_TYPE_FLAG, "FLAG_TYPE_FLAG", "flag"}, {FLAG_TYPE_MAYBE, "FLAG_TYPE_MAYBE", "maybe"}, {0, NULL, NULL}};
		GType flag_type_type_id;
		flag_type_type_id = g_enum_register_static ("FlagType", values);
		g_once_init_leave (&flag_type_type_id__volatile, flag_type_type_id);
	}
	return flag_type_type_id__volatile;
}


Location* location_construct (GType object_type) {
	Location* self = NULL;
	self = (Location*) g_type_create_instance (object_type);
	return self;
}


Location* location_new (void) {
	return location_construct (TYPE_LOCATION);
}


static void value_location_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_location_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		location_unref (value->data[0].v_pointer);
	}
}


static void value_location_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_location_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_location_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Location* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_location_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Location** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = location_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_location (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_location (GValue* value, gpointer v_object) {
	Location* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		location_unref (old);
	}
}


void value_take_location (GValue* value, gpointer v_object) {
	Location* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		location_unref (old);
	}
}


static void location_class_init (LocationClass * klass) {
	location_parent_class = g_type_class_peek_parent (klass);
	LOCATION_CLASS (klass)->finalize = location_finalize;
}


static void location_instance_init (Location * self) {
	self->has_mine = FALSE;
	self->cleared = FALSE;
	self->flag = FLAG_TYPE_NONE;
	self->ref_count = 1;
}


static void location_finalize (Location* obj) {
	Location * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCATION, Location);
}


GType location_get_type (void) {
	static volatile gsize location_type_id__volatile = 0;
	if (g_once_init_enter (&location_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_location_init, value_location_free_value, value_location_copy_value, value_location_peek_pointer, "p", value_location_collect_value, "p", value_location_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Location), 0, (GInstanceInitFunc) location_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType location_type_id;
		location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Location", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&location_type_id__volatile, location_type_id);
	}
	return location_type_id__volatile;
}


gpointer location_ref (gpointer instance) {
	Location* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void location_unref (gpointer instance) {
	Location* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Neighbour* neighbour_dup (const Neighbour* self) {
	Neighbour* dup;
	dup = g_new0 (Neighbour, 1);
	memcpy (dup, self, sizeof (Neighbour));
	return dup;
}


void neighbour_free (Neighbour* self) {
	g_free (self);
}


GType neighbour_get_type (void) {
	static volatile gsize neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&neighbour_type_id__volatile)) {
		GType neighbour_type_id;
		neighbour_type_id = g_boxed_type_register_static ("Neighbour", (GBoxedCopyFunc) neighbour_dup, (GBoxedFreeFunc) neighbour_free);
		g_once_init_leave (&neighbour_type_id__volatile, neighbour_type_id);
	}
	return neighbour_type_id__volatile;
}


Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines) {
	Minefield* self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	Location** _tmp2_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	self = (Minefield*) g_type_create_instance (object_type);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_new0 (Location*, (_tmp0_ * _tmp1_) + 1);
	self->priv->locations = (_vala_array_free (self->priv->locations, self->priv->locations_length1 * self->priv->locations_length2, (GDestroyNotify) location_unref), NULL);
	self->priv->locations = _tmp2_;
	self->priv->locations_length1 = _tmp0_;
	self->priv->locations_length2 = _tmp1_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				guint _tmp6_ = 0U;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = x;
					x = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = x;
				_tmp6_ = width;
				if (!(((guint) _tmp5_) < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							guint _tmp10_ = 0U;
							Location** _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Location* _tmp14_ = NULL;
							Location* _tmp15_ = NULL;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = height;
							if (!(((guint) _tmp9_) < _tmp10_)) {
								break;
							}
							_tmp11_ = self->priv->locations;
							_tmp11__length1 = self->priv->locations_length1;
							_tmp11__length2 = self->priv->locations_length2;
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = location_new ();
							_location_unref0 (_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_]);
							_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
							_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
						}
					}
				}
			}
		}
	}
	_tmp16_ = width;
	self->width = _tmp16_;
	_tmp17_ = height;
	self->height = _tmp17_;
	_tmp18_ = n_mines;
	self->n_mines = _tmp18_;
	return self;
}


Minefield* minefield_new (guint width, guint height, guint n_mines) {
	return minefield_construct (TYPE_MINEFIELD, width, height, n_mines);
}


gboolean minefield_is_clock_started (Minefield* self) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_elapsed (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > ((gdouble) 0);
	return result;
}


gboolean minefield_has_mine (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->has_mine;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_cleared (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_location (Minefield* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_ = 0;
		_tmp4_ = y;
		_tmp2_ = _tmp4_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp5_ = 0;
		guint _tmp6_ = 0U;
		_tmp5_ = x;
		_tmp6_ = self->width;
		_tmp1_ = ((guint) _tmp5_) < _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp7_ = 0;
		guint _tmp8_ = 0U;
		_tmp7_ = y;
		_tmp8_ = self->height;
		_tmp0_ = ((guint) _tmp7_) < _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


void minefield_clear_mine (Minefield* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Location** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	Location* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	Location** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	Location* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	minefield_start_clock (self);
	_tmp0_ = self->priv->placed_mines;
	if (!_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = x;
		_tmp2_ = y;
		minefield_place_mines (self, _tmp1_, _tmp2_);
		self->priv->placed_mines = TRUE;
	}
	_tmp4_ = self->priv->locations;
	_tmp4__length1 = self->priv->locations_length1;
	_tmp4__length2 = self->priv->locations_length2;
	_tmp5_ = x;
	_tmp6_ = y;
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
	_tmp8_ = _tmp7_->cleared;
	if (_tmp8_) {
		_tmp3_ = TRUE;
	} else {
		Location** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp9__length2 = 0;
		guint _tmp10_ = 0U;
		guint _tmp11_ = 0U;
		Location* _tmp12_ = NULL;
		FlagType _tmp13_ = 0;
		_tmp9_ = self->priv->locations;
		_tmp9__length1 = self->priv->locations_length1;
		_tmp9__length2 = self->priv->locations_length2;
		_tmp10_ = x;
		_tmp11_ = y;
		_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
		_tmp13_ = _tmp12_->flag;
		_tmp3_ = _tmp13_ == FLAG_TYPE_FLAG;
	}
	if (_tmp3_) {
		return;
	}
	_tmp14_ = x;
	_tmp15_ = y;
	minefield_clear_mines_recursive (self, _tmp14_, _tmp15_);
	_tmp16_ = self->priv->locations;
	_tmp16__length1 = self->priv->locations_length1;
	_tmp16__length2 = self->priv->locations_length2;
	_tmp17_ = x;
	_tmp18_ = y;
	_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
	_tmp20_ = _tmp19_->has_mine;
	if (_tmp20_) {
		gboolean _tmp21_ = FALSE;
		_tmp21_ = self->exploded;
		if (!_tmp21_) {
			self->exploded = TRUE;
			minefield_stop_clock (self);
			g_signal_emit_by_name (self, "explode");
		}
		return;
	}
	_tmp22_ = minefield_get_is_complete (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		minefield_stop_clock (self);
		{
			gint tx = 0;
			tx = 0;
			{
				gboolean _tmp24_ = FALSE;
				_tmp24_ = TRUE;
				while (TRUE) {
					gint _tmp26_ = 0;
					guint _tmp27_ = 0U;
					if (!_tmp24_) {
						gint _tmp25_ = 0;
						_tmp25_ = tx;
						tx = _tmp25_ + 1;
					}
					_tmp24_ = FALSE;
					_tmp26_ = tx;
					_tmp27_ = self->width;
					if (!(((guint) _tmp26_) < _tmp27_)) {
						break;
					}
					{
						gint ty = 0;
						ty = 0;
						{
							gboolean _tmp28_ = FALSE;
							_tmp28_ = TRUE;
							while (TRUE) {
								gint _tmp30_ = 0;
								guint _tmp31_ = 0U;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								gboolean _tmp34_ = FALSE;
								if (!_tmp28_) {
									gint _tmp29_ = 0;
									_tmp29_ = ty;
									ty = _tmp29_ + 1;
								}
								_tmp28_ = FALSE;
								_tmp30_ = ty;
								_tmp31_ = self->height;
								if (!(((guint) _tmp30_) < _tmp31_)) {
									break;
								}
								_tmp32_ = tx;
								_tmp33_ = ty;
								_tmp34_ = minefield_has_mine (self, (guint) _tmp32_, (guint) _tmp33_);
								if (_tmp34_) {
									gint _tmp35_ = 0;
									gint _tmp36_ = 0;
									_tmp35_ = tx;
									_tmp36_ = ty;
									minefield_set_flag (self, (guint) _tmp35_, (guint) _tmp36_, FLAG_TYPE_FLAG);
								}
							}
						}
					}
				}
			}
		}
		g_signal_emit_by_name (self, "cleared");
	}
}


static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y) {
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	Location** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Location* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	Location** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	Location* _tmp14_ = NULL;
	FlagType _tmp15_ = 0;
	Location** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp18__length2 = 0;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	Location* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	gboolean _tmp24_ = FALSE;
	Location** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	Location* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->locations;
	_tmp5__length1 = self->priv->locations_length1;
	_tmp5__length2 = self->priv->locations_length2;
	_tmp6_ = x;
	_tmp7_ = y;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp8_->cleared = TRUE;
	_tmp9_ = minefield_get_n_cleared (self);
	_tmp10_ = _tmp9_;
	minefield_set_n_cleared (self, _tmp10_ + 1);
	_tmp11_ = self->priv->locations;
	_tmp11__length1 = self->priv->locations_length1;
	_tmp11__length2 = self->priv->locations_length2;
	_tmp12_ = x;
	_tmp13_ = y;
	_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
	_tmp15_ = _tmp14_->flag;
	if (_tmp15_ == FLAG_TYPE_FLAG) {
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		_tmp16_ = minefield_get_n_flags (self);
		_tmp17_ = _tmp16_;
		minefield_set_n_flags (self, _tmp17_ - 1);
	}
	_tmp18_ = self->priv->locations;
	_tmp18__length1 = self->priv->locations_length1;
	_tmp18__length2 = self->priv->locations_length2;
	_tmp19_ = x;
	_tmp20_ = y;
	_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
	_tmp21_->flag = FLAG_TYPE_NONE;
	_tmp22_ = x;
	_tmp23_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp22_, _tmp23_);
	g_signal_emit_by_name (self, "marks-changed");
	_tmp25_ = self->priv->locations;
	_tmp25__length1 = self->priv->locations_length1;
	_tmp25__length2 = self->priv->locations_length2;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
	_tmp29_ = _tmp28_->has_mine;
	if (!_tmp29_) {
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		guint _tmp32_ = 0U;
		_tmp30_ = x;
		_tmp31_ = y;
		_tmp32_ = minefield_get_n_adjacent_mines (self, _tmp30_, _tmp31_);
		_tmp24_ = _tmp32_ == ((guint) 0);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					gint nx = 0;
					guint _tmp33_ = 0U;
					Neighbour _tmp34_ = {0};
					gint _tmp35_ = 0;
					gint ny = 0;
					guint _tmp36_ = 0U;
					Neighbour _tmp37_ = {0};
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gboolean _tmp41_ = FALSE;
					_tmp33_ = x;
					_tmp34_ = neighbour;
					_tmp35_ = _tmp34_.x;
					nx = ((gint) _tmp33_) + _tmp35_;
					_tmp36_ = y;
					_tmp37_ = neighbour;
					_tmp38_ = _tmp37_.y;
					ny = ((gint) _tmp36_) + _tmp38_;
					_tmp39_ = nx;
					_tmp40_ = ny;
					_tmp41_ = minefield_is_location (self, _tmp39_, _tmp40_);
					if (_tmp41_) {
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						_tmp42_ = nx;
						_tmp43_ = ny;
						minefield_clear_mines_recursive (self, (guint) _tmp42_, (guint) _tmp43_);
					}
				}
			}
		}
	}
}


void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag) {
	gboolean _tmp0_ = FALSE;
	Location** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Location* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	FlagType _tmp12_ = 0;
	Location** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp22__length2 = 0;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	Location* _tmp25_ = NULL;
	FlagType _tmp26_ = 0;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->locations;
	_tmp1__length1 = self->priv->locations_length1;
	_tmp1__length2 = self->priv->locations_length2;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = _tmp1_[(_tmp2_ * _tmp1__length2) + _tmp3_];
	_tmp5_ = _tmp4_->cleared;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Location** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint _tmp6__length2 = 0;
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		Location* _tmp9_ = NULL;
		FlagType _tmp10_ = 0;
		FlagType _tmp11_ = 0;
		_tmp6_ = self->priv->locations;
		_tmp6__length1 = self->priv->locations_length1;
		_tmp6__length2 = self->priv->locations_length2;
		_tmp7_ = x;
		_tmp8_ = y;
		_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
		_tmp10_ = _tmp9_->flag;
		_tmp11_ = flag;
		_tmp0_ = _tmp10_ == _tmp11_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp12_ = flag;
	if (_tmp12_ == FLAG_TYPE_FLAG) {
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		_tmp13_ = minefield_get_n_flags (self);
		_tmp14_ = _tmp13_;
		minefield_set_n_flags (self, _tmp14_ + 1);
	} else {
		Location** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp15__length2 = 0;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		Location* _tmp18_ = NULL;
		FlagType _tmp19_ = 0;
		_tmp15_ = self->priv->locations;
		_tmp15__length1 = self->priv->locations_length1;
		_tmp15__length2 = self->priv->locations_length2;
		_tmp16_ = x;
		_tmp17_ = y;
		_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
		_tmp19_ = _tmp18_->flag;
		if (_tmp19_ == FLAG_TYPE_FLAG) {
			guint _tmp20_ = 0U;
			guint _tmp21_ = 0U;
			_tmp20_ = minefield_get_n_flags (self);
			_tmp21_ = _tmp20_;
			minefield_set_n_flags (self, _tmp21_ - 1);
		}
	}
	_tmp22_ = self->priv->locations;
	_tmp22__length1 = self->priv->locations_length1;
	_tmp22__length2 = self->priv->locations_length2;
	_tmp23_ = x;
	_tmp24_ = y;
	_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
	_tmp26_ = flag;
	_tmp25_->flag = _tmp26_;
	_tmp27_ = x;
	_tmp28_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp27_, _tmp28_);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp29_ = 0U;
				Neighbour _tmp30_ = {0};
				gint _tmp31_ = 0;
				gint ny = 0;
				guint _tmp32_ = 0U;
				Neighbour _tmp33_ = {0};
				gint _tmp34_ = 0;
				gboolean _tmp35_ = FALSE;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gboolean _tmp38_ = FALSE;
				_tmp29_ = x;
				_tmp30_ = neighbour;
				_tmp31_ = _tmp30_.x;
				nx = ((gint) _tmp29_) + _tmp31_;
				_tmp32_ = y;
				_tmp33_ = neighbour;
				_tmp34_ = _tmp33_.y;
				ny = ((gint) _tmp32_) + _tmp34_;
				_tmp36_ = nx;
				_tmp37_ = ny;
				_tmp38_ = minefield_is_location (self, _tmp36_, _tmp37_);
				if (_tmp38_) {
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gboolean _tmp41_ = FALSE;
					_tmp39_ = nx;
					_tmp40_ = ny;
					_tmp41_ = minefield_is_cleared (self, (guint) _tmp39_, (guint) _tmp40_);
					_tmp35_ = _tmp41_;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					_tmp42_ = nx;
					_tmp43_ = ny;
					g_signal_emit_by_name (self, "redraw-sector", (guint) _tmp42_, (guint) _tmp43_);
				}
			}
		}
	}
	g_signal_emit_by_name (self, "marks-changed");
}


FlagType minefield_get_flag (Minefield* self, guint x, guint y) {
	FlagType result = 0;
	Location** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Location* _tmp3_ = NULL;
	FlagType _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->flag;
	result = _tmp4_;
	return result;
}


static gpointer _location_ref0 (gpointer self) {
	return self ? location_ref (self) : NULL;
}


void minefield_hint (Minefield* self) {
	GList* case1list = NULL;
	GList* case2list = NULL;
	GList* case3list = NULL;
	guint hint_location = 0U;
	GList* _tmp49_ = NULL;
	guint _tmp50_ = 0U;
	guint x = 0U;
	guint _tmp70_ = 0U;
	guint _tmp71_ = 0U;
	guint y = 0U;
	guint _tmp72_ = 0U;
	guint _tmp73_ = 0U;
	Location** _tmp74_ = NULL;
	gint _tmp74__length1 = 0;
	gint _tmp74__length2 = 0;
	guint _tmp75_ = 0U;
	guint _tmp76_ = 0U;
	Location* _tmp77_ = NULL;
	FlagType _tmp78_ = 0;
	guint _tmp83_ = 0U;
	guint _tmp84_ = 0U;
	gdouble _tmp85_ = 0.0;
	guint _tmp86_ = 0U;
	guint _tmp87_ = 0U;
	g_return_if_fail (self != NULL);
	case1list = NULL;
	case2list = NULL;
	case3list = NULL;
	{
		gint mx = 0;
		mx = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = mx;
					mx = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = mx;
				_tmp3_ = self->width;
				if (!(((guint) _tmp2_) < _tmp3_)) {
					break;
				}
				{
					gint my = 0;
					my = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							guint _tmp7_ = 0U;
							Location* m = NULL;
							Location** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Location* _tmp11_ = NULL;
							Location* _tmp12_ = NULL;
							gboolean _tmp13_ = FALSE;
							Location* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = my;
								my = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = my;
							_tmp7_ = self->height;
							if (!(((guint) _tmp6_) < _tmp7_)) {
								break;
							}
							_tmp8_ = self->priv->locations;
							_tmp8__length1 = self->priv->locations_length1;
							_tmp8__length2 = self->priv->locations_length2;
							_tmp9_ = mx;
							_tmp10_ = my;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							_tmp12_ = _location_ref0 (_tmp11_);
							m = _tmp12_;
							_tmp14_ = m;
							_tmp15_ = _tmp14_->has_mine;
							if (!_tmp15_) {
								Location* _tmp16_ = NULL;
								gboolean _tmp17_ = FALSE;
								_tmp16_ = m;
								_tmp17_ = _tmp16_->cleared;
								_tmp13_ = !_tmp17_;
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								gint _tmp18_ = 0;
								guint _tmp19_ = 0U;
								gint _tmp20_ = 0;
								gboolean _tmp21_ = FALSE;
								Location* _tmp22_ = NULL;
								FlagType _tmp23_ = 0;
								_tmp18_ = mx;
								_tmp19_ = self->width;
								_tmp20_ = my;
								case3list = g_list_append (case3list, (gpointer) ((guintptr) ((_tmp18_ * _tmp19_) + _tmp20_)));
								_tmp22_ = m;
								_tmp23_ = _tmp22_->flag;
								if (_tmp23_ != FLAG_TYPE_FLAG) {
									gint _tmp24_ = 0;
									gint _tmp25_ = 0;
									guint _tmp26_ = 0U;
									_tmp24_ = mx;
									_tmp25_ = my;
									_tmp26_ = minefield_get_n_adjacent_mines (self, (guint) _tmp24_, (guint) _tmp25_);
									_tmp21_ = _tmp26_ > ((guint) 0);
								} else {
									_tmp21_ = FALSE;
								}
								if (_tmp21_) {
									gint _tmp27_ = 0;
									guint _tmp28_ = 0U;
									gint _tmp29_ = 0;
									_tmp27_ = mx;
									_tmp28_ = self->width;
									_tmp29_ = my;
									case2list = g_list_append (case2list, (gpointer) ((guintptr) ((_tmp27_ * _tmp28_) + _tmp29_)));
									{
										Neighbour* neighbour_collection = NULL;
										gint neighbour_collection_length1 = 0;
										gint _neighbour_collection_size_ = 0;
										gint neighbour_it = 0;
										neighbour_collection = neighbour_map;
										neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
										for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
											Neighbour neighbour = {0};
											neighbour = neighbour_collection[neighbour_it];
											{
												gint _tmp30_ = 0;
												Neighbour _tmp31_ = {0};
												gint _tmp32_ = 0;
												gint _tmp33_ = 0;
												Neighbour _tmp34_ = {0};
												gint _tmp35_ = 0;
												gboolean _tmp36_ = FALSE;
												Location** _tmp37_ = NULL;
												gint _tmp37__length1 = 0;
												gint _tmp37__length2 = 0;
												gint _tmp38_ = 0;
												Neighbour _tmp39_ = {0};
												gint _tmp40_ = 0;
												gint _tmp41_ = 0;
												Neighbour _tmp42_ = {0};
												gint _tmp43_ = 0;
												Location* _tmp44_ = NULL;
												gboolean _tmp45_ = FALSE;
												_tmp30_ = mx;
												_tmp31_ = neighbour;
												_tmp32_ = _tmp31_.x;
												_tmp33_ = my;
												_tmp34_ = neighbour;
												_tmp35_ = _tmp34_.y;
												_tmp36_ = minefield_is_location (self, _tmp30_ + _tmp32_, _tmp33_ + _tmp35_);
												if (!_tmp36_) {
													continue;
												}
												_tmp37_ = self->priv->locations;
												_tmp37__length1 = self->priv->locations_length1;
												_tmp37__length2 = self->priv->locations_length2;
												_tmp38_ = mx;
												_tmp39_ = neighbour;
												_tmp40_ = _tmp39_.x;
												_tmp41_ = my;
												_tmp42_ = neighbour;
												_tmp43_ = _tmp42_.y;
												_tmp44_ = _tmp37_[((_tmp38_ + _tmp40_) * _tmp37__length2) + (_tmp41_ + _tmp43_)];
												_tmp45_ = _tmp44_->cleared;
												if (_tmp45_) {
													gint _tmp46_ = 0;
													guint _tmp47_ = 0U;
													gint _tmp48_ = 0;
													_tmp46_ = mx;
													_tmp47_ = self->width;
													_tmp48_ = my;
													case1list = g_list_append (case1list, (gpointer) ((guintptr) ((_tmp46_ * _tmp47_) + _tmp48_)));
													break;
												}
											}
										}
									}
								}
							}
							_location_unref0 (m);
						}
					}
				}
			}
		}
	}
	hint_location = (guint) 0;
	_tmp49_ = case1list;
	_tmp50_ = g_list_length (_tmp49_);
	if (_tmp50_ > ((guint) 0)) {
		GList* _tmp51_ = NULL;
		GList* _tmp52_ = NULL;
		guint _tmp53_ = 0U;
		gint32 _tmp54_ = 0;
		gconstpointer _tmp55_ = NULL;
		_tmp51_ = case1list;
		_tmp52_ = case1list;
		_tmp53_ = g_list_length (_tmp52_);
		_tmp54_ = g_random_int_range ((gint32) 0, (gint32) _tmp53_);
		_tmp55_ = g_list_nth_data (_tmp51_, (guint) _tmp54_);
		hint_location = (guint) ((guintptr) _tmp55_);
	} else {
		GList* _tmp56_ = NULL;
		guint _tmp57_ = 0U;
		_tmp56_ = case2list;
		_tmp57_ = g_list_length (_tmp56_);
		if (_tmp57_ > ((guint) 0)) {
			GList* _tmp58_ = NULL;
			GList* _tmp59_ = NULL;
			guint _tmp60_ = 0U;
			gint32 _tmp61_ = 0;
			gconstpointer _tmp62_ = NULL;
			_tmp58_ = case2list;
			_tmp59_ = case2list;
			_tmp60_ = g_list_length (_tmp59_);
			_tmp61_ = g_random_int_range ((gint32) 0, (gint32) _tmp60_);
			_tmp62_ = g_list_nth_data (_tmp58_, (guint) _tmp61_);
			hint_location = (guint) ((guintptr) _tmp62_);
		} else {
			GList* _tmp63_ = NULL;
			guint _tmp64_ = 0U;
			_tmp63_ = case3list;
			_tmp64_ = g_list_length (_tmp63_);
			if (_tmp64_ > ((guint) 0)) {
				GList* _tmp65_ = NULL;
				GList* _tmp66_ = NULL;
				guint _tmp67_ = 0U;
				gint32 _tmp68_ = 0;
				gconstpointer _tmp69_ = NULL;
				_tmp65_ = case3list;
				_tmp66_ = case3list;
				_tmp67_ = g_list_length (_tmp66_);
				_tmp68_ = g_random_int_range ((gint32) 0, (gint32) _tmp67_);
				_tmp69_ = g_list_nth_data (_tmp65_, (guint) _tmp68_);
				hint_location = (guint) ((guintptr) _tmp69_);
			}
		}
	}
	_tmp70_ = hint_location;
	_tmp71_ = self->width;
	x = _tmp70_ / _tmp71_;
	_tmp72_ = hint_location;
	_tmp73_ = self->width;
	y = _tmp72_ % _tmp73_;
	_tmp74_ = self->priv->locations;
	_tmp74__length1 = self->priv->locations_length1;
	_tmp74__length2 = self->priv->locations_length2;
	_tmp75_ = x;
	_tmp76_ = y;
	_tmp77_ = _tmp74_[(_tmp75_ * _tmp74__length2) + _tmp76_];
	_tmp78_ = _tmp77_->flag;
	if (_tmp78_ == FLAG_TYPE_FLAG) {
		Location** _tmp79_ = NULL;
		gint _tmp79__length1 = 0;
		gint _tmp79__length2 = 0;
		guint _tmp80_ = 0U;
		guint _tmp81_ = 0U;
		Location* _tmp82_ = NULL;
		_tmp79_ = self->priv->locations;
		_tmp79__length1 = self->priv->locations_length1;
		_tmp79__length2 = self->priv->locations_length2;
		_tmp80_ = x;
		_tmp81_ = y;
		_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_];
		_tmp82_->flag = FLAG_TYPE_NONE;
	}
	_tmp83_ = x;
	_tmp84_ = y;
	minefield_clear_mine (self, _tmp83_, _tmp84_);
	_tmp85_ = self->priv->clock_elapsed;
	_tmp86_ = self->priv->hint_time_penalty_seconds;
	self->priv->clock_elapsed = _tmp85_ + _tmp86_;
	_tmp87_ = self->priv->hint_time_penalty_seconds;
	if (_tmp87_ < MINEFIELD_HINT_TIME_PENALTY_MAX) {
		guint _tmp88_ = 0U;
		_tmp88_ = self->priv->hint_time_penalty_seconds;
		self->priv->hint_time_penalty_seconds = _tmp88_ + MINEFIELD_HINT_TIME_PENALTY_INCREASE;
	}
	g_signal_emit_by_name (self, "tick");
	_g_list_free0 (case3list);
	_g_list_free0 (case2list);
	_g_list_free0 (case1list);
}


guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y) {
	guint result = 0U;
	guint n = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	n = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp0_ = 0U;
				Neighbour _tmp1_ = {0};
				gint _tmp2_ = 0;
				gint ny = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = ((gint) _tmp0_) + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = ((gint) _tmp3_) + _tmp5_;
				_tmp7_ = nx;
				_tmp8_ = ny;
				_tmp9_ = minefield_is_location (self, _tmp7_, _tmp8_);
				if (_tmp9_) {
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gboolean _tmp12_ = FALSE;
					_tmp10_ = nx;
					_tmp11_ = ny;
					_tmp12_ = minefield_has_mine (self, (guint) _tmp10_, (guint) _tmp11_);
					_tmp6_ = _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					guint _tmp13_ = 0U;
					_tmp13_ = n;
					n = _tmp13_ + 1;
				}
			}
		}
	}
	result = n;
	return result;
}


gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	guint n_mines = 0U;
	guint n_flags = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = minefield_is_cleared (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	n_mines = (guint) 0;
	n_flags = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				gint ny = 0;
				guint _tmp6_ = 0U;
				Neighbour _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				FlagType _tmp18_ = 0;
				_tmp3_ = x;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.x;
				nx = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = y;
				_tmp7_ = neighbour;
				_tmp8_ = _tmp7_.y;
				ny = ((gint) _tmp6_) + _tmp8_;
				_tmp9_ = nx;
				_tmp10_ = ny;
				_tmp11_ = minefield_is_location (self, _tmp9_, _tmp10_);
				if (!_tmp11_) {
					continue;
				}
				_tmp12_ = nx;
				_tmp13_ = ny;
				_tmp14_ = minefield_has_mine (self, (guint) _tmp12_, (guint) _tmp13_);
				if (_tmp14_) {
					guint _tmp15_ = 0U;
					_tmp15_ = n_mines;
					n_mines = _tmp15_ + 1;
				}
				_tmp16_ = nx;
				_tmp17_ = ny;
				_tmp18_ = minefield_get_flag (self, (guint) _tmp16_, (guint) _tmp17_);
				if (_tmp18_ == FLAG_TYPE_FLAG) {
					guint _tmp19_ = 0U;
					_tmp19_ = n_flags;
					n_flags = _tmp19_ + 1;
				}
			}
		}
	}
	_tmp20_ = n_flags;
	_tmp21_ = n_mines;
	result = _tmp20_ > _tmp21_;
	return result;
}


static void minefield_place_mines (Minefield* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_ = 0;
				guint _tmp2_ = 0U;
				gint32 rx = 0;
				guint _tmp3_ = 0U;
				gint32 _tmp4_ = 0;
				gint32 ry = 0;
				guint _tmp5_ = 0U;
				gint32 _tmp6_ = 0;
				gboolean _tmp7_ = FALSE;
				gint32 _tmp8_ = 0;
				guint _tmp9_ = 0U;
				Location** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp12__length2 = 0;
				gint32 _tmp13_ = 0;
				gint32 _tmp14_ = 0;
				Location* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp1_ = n;
				_tmp2_ = self->n_mines;
				if (!(((guint) _tmp1_) < _tmp2_)) {
					break;
				}
				_tmp3_ = self->width;
				_tmp4_ = g_random_int_range ((gint32) 0, (gint32) _tmp3_);
				rx = _tmp4_;
				_tmp5_ = self->height;
				_tmp6_ = g_random_int_range ((gint32) 0, (gint32) _tmp5_);
				ry = _tmp6_;
				_tmp8_ = rx;
				_tmp9_ = x;
				if (((guint) _tmp8_) == _tmp9_) {
					gint32 _tmp10_ = 0;
					guint _tmp11_ = 0U;
					_tmp10_ = ry;
					_tmp11_ = y;
					_tmp7_ = ((guint) _tmp10_) == _tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					continue;
				}
				_tmp12_ = self->priv->locations;
				_tmp12__length1 = self->priv->locations_length1;
				_tmp12__length2 = self->priv->locations_length2;
				_tmp13_ = rx;
				_tmp14_ = ry;
				_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
				_tmp16_ = _tmp15_->has_mine;
				if (!_tmp16_) {
					gboolean adj_found = FALSE;
					gboolean _tmp26_ = FALSE;
					adj_found = FALSE;
					{
						Neighbour* neighbour_collection = NULL;
						gint neighbour_collection_length1 = 0;
						gint _neighbour_collection_size_ = 0;
						gint neighbour_it = 0;
						neighbour_collection = neighbour_map;
						neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
						for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
							Neighbour neighbour = {0};
							neighbour = neighbour_collection[neighbour_it];
							{
								gboolean _tmp17_ = FALSE;
								gint32 _tmp18_ = 0;
								guint _tmp19_ = 0U;
								Neighbour _tmp20_ = {0};
								gint _tmp21_ = 0;
								_tmp18_ = rx;
								_tmp19_ = x;
								_tmp20_ = neighbour;
								_tmp21_ = _tmp20_.x;
								if (((guint) _tmp18_) == (_tmp19_ + _tmp21_)) {
									gint32 _tmp22_ = 0;
									guint _tmp23_ = 0U;
									Neighbour _tmp24_ = {0};
									gint _tmp25_ = 0;
									_tmp22_ = ry;
									_tmp23_ = y;
									_tmp24_ = neighbour;
									_tmp25_ = _tmp24_.y;
									_tmp17_ = ((guint) _tmp22_) == (_tmp23_ + _tmp25_);
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									adj_found = TRUE;
									break;
								}
							}
						}
					}
					_tmp26_ = adj_found;
					if (!_tmp26_) {
						Location** _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp27__length2 = 0;
						gint32 _tmp28_ = 0;
						gint32 _tmp29_ = 0;
						Location* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						_tmp27_ = self->priv->locations;
						_tmp27__length1 = self->priv->locations_length1;
						_tmp27__length2 = self->priv->locations_length2;
						_tmp28_ = rx;
						_tmp29_ = ry;
						_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
						_tmp30_->has_mine = TRUE;
						_tmp31_ = n;
						n = _tmp31_ + 1;
					}
				}
			}
		}
	}
}


static void minefield_start_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	}
	g_signal_emit_by_name (self, "clock-started");
	minefield_timeout_cb (self);
}


static void minefield_stop_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->clock_timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->clock_timeout;
		g_source_remove (_tmp2_);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp3_ = self->priv->clock;
	g_timer_stop (_tmp3_);
	g_signal_emit_by_name (self, "tick");
}


static void minefield_continue_clock (Minefield* self) {
	GTimer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_ = NULL;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	} else {
		GTimer* _tmp2_ = NULL;
		_tmp2_ = self->priv->clock;
		g_timer_continue (_tmp2_);
	}
	minefield_timeout_cb (self);
}


static gboolean _minefield_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = minefield_timeout_cb ((Minefield*) self);
	return result;
}


static gboolean minefield_timeout_cb (Minefield* self) {
	gboolean result = FALSE;
	gdouble elapsed = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gint next = 0;
	gdouble wait = 0.0;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->clock;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	elapsed = _tmp1_;
	next = (gint) (elapsed + 1.0);
	wait = next - elapsed;
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (wait * 1000)), _minefield_timeout_cb_gsource_func, minefield_ref (self), minefield_unref);
	self->priv->clock_timeout = _tmp2_;
	g_signal_emit_by_name (self, "tick");
	result = FALSE;
	return result;
}


guint minefield_get_n_cleared (Minefield* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_n_cleared;
	result = _tmp0_;
	return result;
}


void minefield_set_n_cleared (Minefield* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_cleared = _tmp0_;
}


gboolean minefield_get_is_complete (Minefield* self) {
	gboolean result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_n_cleared (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->width;
	_tmp3_ = self->height;
	_tmp4_ = self->n_mines;
	result = _tmp1_ == ((_tmp2_ * _tmp3_) - _tmp4_);
	return result;
}


guint minefield_get_n_flags (Minefield* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_n_flags;
	result = _tmp0_;
	return result;
}


void minefield_set_n_flags (Minefield* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_n_flags = _tmp0_;
}


gdouble minefield_get_elapsed (Minefield* self) {
	gdouble result;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		result = 0.0;
		return result;
	}
	_tmp1_ = self->priv->clock_elapsed;
	_tmp2_ = self->priv->clock;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	result = _tmp1_ + _tmp3_;
	return result;
}


gboolean minefield_get_paused (Minefield* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void minefield_set_paused (Minefield* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GTimer* _tmp4_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_get_is_complete (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->exploded;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->clock;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp6_ = value;
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			_tmp7_ = self->priv->_paused;
			_tmp5_ = !_tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			minefield_stop_clock (self);
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			_tmp9_ = value;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				_tmp10_ = self->priv->_paused;
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				minefield_continue_clock (self);
			}
		}
	}
	_tmp11_ = value;
	self->priv->_paused = _tmp11_;
	g_signal_emit_by_name (self, "paused-changed");
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void value_minefield_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_minefield_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		minefield_unref (value->data[0].v_pointer);
	}
}


static void value_minefield_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = minefield_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_minefield_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_minefield_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Minefield* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = minefield_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_minefield_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Minefield** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = minefield_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMinefield* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MINEFIELD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_minefield (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD), NULL);
	return value->data[0].v_pointer;
}


void value_set_minefield (GValue* value, gpointer v_object) {
	Minefield* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINEFIELD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		minefield_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minefield_unref (old);
	}
}


void value_take_minefield (GValue* value, gpointer v_object) {
	Minefield* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINEFIELD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minefield_unref (old);
	}
}


static void minefield_class_init (MinefieldClass * klass) {
	minefield_parent_class = g_type_class_peek_parent (klass);
	MINEFIELD_CLASS (klass)->finalize = minefield_finalize;
	g_type_class_add_private (klass, sizeof (MinefieldPrivate));
	g_signal_new ("clock_started", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("paused_changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("tick", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("redraw_sector", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("marks_changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("explode", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_instance_init (Minefield * self) {
	self->priv = MINEFIELD_GET_PRIVATE (self);
	self->width = (guint) 0;
	self->height = (guint) 0;
	self->n_mines = (guint) 0;
	self->exploded = FALSE;
	self->priv->placed_mines = FALSE;
	self->priv->_n_cleared = (guint) 0;
	self->priv->_n_flags = (guint) 0;
	self->priv->hint_time_penalty_seconds = (guint) 10;
	self->priv->_paused = FALSE;
	self->ref_count = 1;
}


static void minefield_finalize (Minefield* obj) {
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD, Minefield);
	self->priv->locations = (_vala_array_free (self->priv->locations, self->priv->locations_length1 * self->priv->locations_length2, (GDestroyNotify) location_unref), NULL);
	_g_timer_destroy0 (self->priv->clock);
}


GType minefield_get_type (void) {
	static volatile gsize minefield_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_minefield_init, value_minefield_free_value, value_minefield_copy_value, value_minefield_peek_pointer, "p", value_minefield_collect_value, "p", value_minefield_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Minefield), 0, (GInstanceInitFunc) minefield_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType minefield_type_id;
		minefield_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Minefield", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&minefield_type_id__volatile, minefield_type_id);
	}
	return minefield_type_id__volatile;
}


gpointer minefield_ref (gpointer instance) {
	Minefield* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void minefield_unref (gpointer instance) {
	Minefield* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MINEFIELD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



