/* rygel-mpris-plugin.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-mpris-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMPRISPluginPrivate RygelMPRISPluginPrivate;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MPRIS_TYPE_PLAYER (rygel_mpris_player_get_type ())
#define RYGEL_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer))
#define RYGEL_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))
#define RYGEL_MPRIS_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))

typedef struct _RygelMPRISPlayer RygelMPRISPlayer;
typedef struct _RygelMPRISPlayerClass RygelMPRISPlayerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMPRISPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelMPRISPluginPrivate * priv;
};

struct _RygelMPRISPluginClass {
	RygelMediaRendererPluginClass parent_class;
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error);
	char* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	double (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, double value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISPluginPrivate {
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	FreeDesktopProperties* properties;
	char** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	char** protocols;
	gint protocols_length1;
	gint _protocols_size_;
};


static gpointer rygel_mpris_plugin_parent_class = NULL;

GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
RygelMPRISMediaPlayerPlayerProxy* rygel_mpris_media_player_player_proxy_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginPrivate))
enum  {
	RYGEL_MPRIS_PLUGIN_DUMMY_PROPERTY
};
#define RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
RygelMPRISPlugin* rygel_mpris_plugin_new (const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1);
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type, const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1);
static char** _vala_array_dup5 (char** self, int length);
static char** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self, char** schemes, int schemes_length1, int* result_length1);
static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base);
RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISMediaPlayerPlayerProxy* actual_player, FreeDesktopProperties* properties, char** mime_types, int mime_types_length1, char** protocols, int protocols_length1);
RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISMediaPlayerPlayerProxy* actual_player, FreeDesktopProperties* properties, char** mime_types, int mime_types_length1, char** protocols, int protocols_length1);
GType rygel_mpris_player_get_type (void) G_GNUC_CONST;
static char* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self, const char* scheme);
static void rygel_mpris_plugin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static char** _vala_array_dup5 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 38 "rygel-mpris-plugin.vala"
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type, const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1) {
#line 147 "rygel-mpris-plugin.c"
	RygelMPRISPlugin * self;
	char** _tmp0_;
	char** _tmp1_;
	gint _tmp2_;
	char** _tmp3_;
	GError * _inner_error_ = NULL;
#line 38 "rygel-mpris-plugin.vala"
	g_return_val_if_fail (service_name != NULL, NULL);
#line 38 "rygel-mpris-plugin.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 42 "rygel-mpris-plugin.vala"
	self = (RygelMPRISPlugin*) rygel_media_renderer_plugin_construct (object_type, service_name, title, NULL);
#line 44 "rygel-mpris-plugin.vala"
	self->priv->mime_types = (_tmp1_ = (_tmp0_ = mime_types, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup5 (_tmp0_, mime_types_length1)), self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL), self->priv->mime_types_length1 = mime_types_length1, self->priv->_mime_types_size_ = self->priv->mime_types_length1, _tmp1_);
#line 45 "rygel-mpris-plugin.vala"
	self->priv->protocols = (_tmp3_ = rygel_mpris_plugin_schemes_to_protocols (self, schemes, schemes_length1, &_tmp2_), self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL), self->priv->protocols_length1 = _tmp2_, self->priv->_protocols_size_ = self->priv->protocols_length1, _tmp3_);
#line 164 "rygel-mpris-plugin.c"
	{
		DBusGConnection* connection;
		RygelMPRISMediaPlayerPlayerProxy* _tmp4_;
		FreeDesktopProperties* _tmp5_;
#line 48 "rygel-mpris-plugin.vala"
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 171 "rygel-mpris-plugin.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
#line 51 "rygel-mpris-plugin.vala"
		self->priv->actual_player = (_tmp4_ = rygel_mpris_media_player_player_proxy_dbus_proxy_new (connection, service_name, RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH), _g_object_unref0 (self->priv->actual_player), _tmp4_);
#line 55 "rygel-mpris-plugin.vala"
		self->priv->properties = (_tmp5_ = free_desktop_properties_dbus_proxy_new (connection, service_name, RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH), _g_object_unref0 (self->priv->properties), _tmp5_);
#line 179 "rygel-mpris-plugin.c"
		_dbus_g_connection_unref0 (connection);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 59 "rygel-mpris-plugin.vala"
			g_critical ("rygel-mpris-plugin.vala:59: Failed to connect to session bus: %s", err->message);
#line 191 "rygel-mpris-plugin.c"
			_g_error_free0 (err);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


#line 38 "rygel-mpris-plugin.vala"
RygelMPRISPlugin* rygel_mpris_plugin_new (const char* service_name, const char* title, char** mime_types, int mime_types_length1, char** schemes, int schemes_length1) {
#line 38 "rygel-mpris-plugin.vala"
	return rygel_mpris_plugin_construct (RYGEL_MPRIS_TYPE_PLUGIN, service_name, title, mime_types, mime_types_length1, schemes, schemes_length1);
#line 209 "rygel-mpris-plugin.c"
}


#line 63 "rygel-mpris-plugin.vala"
static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base) {
#line 215 "rygel-mpris-plugin.c"
	RygelMPRISPlugin * self;
	RygelMediaPlayer* result = NULL;
	self = (RygelMPRISPlugin*) base;
	result = (RygelMediaPlayer*) rygel_mpris_player_new (self->priv->actual_player, self->priv->properties, self->priv->mime_types, self->priv->mime_types_length1, self->priv->protocols, self->priv->protocols_length1);
#line 64 "rygel-mpris-plugin.vala"
	return result;
#line 222 "rygel-mpris-plugin.c"
}


#line 70 "rygel-mpris-plugin.vala"
static char** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self, char** schemes, int schemes_length1, int* result_length1) {
#line 228 "rygel-mpris-plugin.c"
	char** result = NULL;
	gint protocols_length1;
	gint _protocols_size_;
	char** _tmp0_;
	char** protocols;
	char** _tmp3_;
#line 70 "rygel-mpris-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "rygel-mpris-plugin.c"
	protocols = (_tmp0_ = g_new0 (char*, schemes_length1 + 1), protocols_length1 = schemes_length1, _protocols_size_ = protocols_length1, _tmp0_);
	{
		gint i;
#line 73 "rygel-mpris-plugin.vala"
		i = 0;
#line 243 "rygel-mpris-plugin.c"
		{
			gboolean _tmp1_;
#line 73 "rygel-mpris-plugin.vala"
			_tmp1_ = TRUE;
#line 73 "rygel-mpris-plugin.vala"
			while (TRUE) {
#line 250 "rygel-mpris-plugin.c"
				char* _tmp2_;
#line 73 "rygel-mpris-plugin.vala"
				if (!_tmp1_) {
#line 73 "rygel-mpris-plugin.vala"
					i++;
#line 256 "rygel-mpris-plugin.c"
				}
#line 73 "rygel-mpris-plugin.vala"
				_tmp1_ = FALSE;
#line 73 "rygel-mpris-plugin.vala"
				if (!(i < schemes_length1)) {
#line 73 "rygel-mpris-plugin.vala"
					break;
#line 264 "rygel-mpris-plugin.c"
				}
#line 74 "rygel-mpris-plugin.vala"
				protocols[i] = (_tmp2_ = rygel_mpris_plugin_scheme_to_protocol (self, schemes[i]), _g_free0 (protocols[i]), _tmp2_);
#line 268 "rygel-mpris-plugin.c"
			}
		}
	}
	result = (_tmp3_ = protocols, *result_length1 = protocols_length1, _tmp3_);
#line 77 "rygel-mpris-plugin.vala"
	return result;
#line 275 "rygel-mpris-plugin.c"
	protocols = (_vala_array_free (protocols, protocols_length1, (GDestroyNotify) g_free), NULL);
}


#line 80 "rygel-mpris-plugin.vala"
static char* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self, const char* scheme) {
#line 282 "rygel-mpris-plugin.c"
	char* result = NULL;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
#line 80 "rygel-mpris-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-mpris-plugin.vala"
	g_return_val_if_fail (scheme != NULL, NULL);
#line 292 "rygel-mpris-plugin.c"
	_tmp0_ = scheme;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("http"))))
	switch (0) {
		default:
		{
			result = g_strdup ("http-get");
#line 83 "rygel-mpris-plugin.vala"
			return result;
#line 302 "rygel-mpris-plugin.c"
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("file"))))
	switch (0) {
		default:
		{
			result = g_strdup ("internal");
#line 85 "rygel-mpris-plugin.vala"
			return result;
#line 311 "rygel-mpris-plugin.c"
		}
	} else
	switch (0) {
		default:
		{
			result = g_strdup (scheme);
#line 87 "rygel-mpris-plugin.vala"
			return result;
#line 320 "rygel-mpris-plugin.c"
		}
	}
}


static void rygel_mpris_plugin_class_init (RygelMPRISPluginClass * klass) {
	rygel_mpris_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMPRISPluginPrivate));
	RYGEL_MEDIA_RENDERER_PLUGIN_CLASS (klass)->get_player = rygel_mpris_plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_plugin_finalize;
}


static void rygel_mpris_plugin_instance_init (RygelMPRISPlugin * self) {
	self->priv = RYGEL_MPRIS_PLUGIN_GET_PRIVATE (self);
}


static void rygel_mpris_plugin_finalize (GObject* obj) {
	RygelMPRISPlugin * self;
	self = RYGEL_MPRIS_PLUGIN (obj);
	_g_object_unref0 (self->priv->actual_player);
	_g_object_unref0 (self->priv->properties);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_mpris_plugin_parent_class)->finalize (obj);
}


GType rygel_mpris_plugin_get_type (void) {
	static volatile gsize rygel_mpris_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlugin), 0, (GInstanceInitFunc) rygel_mpris_plugin_instance_init, NULL };
		GType rygel_mpris_plugin_type_id;
		rygel_mpris_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "RygelMPRISPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mpris_plugin_type_id__volatile, rygel_mpris_plugin_type_id);
	}
	return rygel_mpris_plugin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




