/* 
 * JNI utility functions, from the book "The Java Native Interface" by
 * Sheng Liang.
 */

#ifndef _JG_JNU_H_
#define _JG_JNU_H_
#include <jni.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

/** JNU_GetEnv: Returns a valid JNIEnv pointer.  
 *
 * This eliminates the need to store the JNIEnv pointer for 
 * later use in callbacks. 
 */
extern JNIEnv *JNU_GetEnv();

/** JNU_ThrowByName: throws a new Exception.
 *
 * @param env  the JNIEnv pointer
 * @param name the name of the Exception class, such as 
 * "java/lang/NullPointerException".
 * @param msg  the detail message for the exception.
 */
extern void JNU_ThrowByName(JNIEnv *env, const char *name, const char *msg);

    /**
     * Transforms a GSList into an java array of integers
     *
     * @param env the JNIEnv pointer
     * @param list the list to transform into an array
     */
extern jobject getSList(JNIEnv *env, GSList* list);

    /**
     * Transforms a GList into an java array of integers
     *
     * @param env the JNIEnv pointer
     * @param list the list to transform into an array
     */
extern jobject getList(JNIEnv *env, GList* list);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* !_JG_JNU_H_ */
