/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_RadioActionEntry
#define _Included_org_gnu_gtk_RadioActionEntry
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    allocate
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioActionEntry_allocate
  (JNIEnv *env, jclass cls)
{
	GtkRadioActionEntry* entry = (GtkRadioActionEntry*)g_malloc(sizeof(GtkRadioActionEntry));
	return (jint)entry;
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_free
  (JNIEnv *env, jclass cls, jint entry)
{
	GtkRadioActionEntry* e = (GtkRadioActionEntry*)entry;
	g_free(e);
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setName
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setName
  (JNIEnv *env, jclass cls, jint entry, jstring name)
{
	if (NULL == name) {
		((GtkRadioActionEntry*)entry)->name = NULL;
	} else {
		gchar* n = (gchar*)(*env)->GetStringUTFChars(env, name, NULL);
		((GtkRadioActionEntry*)entry)->name = n;
	}
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setStockId
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setStockId
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkRadioActionEntry*)entry)->stock_id = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkRadioActionEntry*)entry)->stock_id = v;
	}
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setLabel
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setLabel
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkRadioActionEntry*)entry)->label = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkRadioActionEntry*)entry)->label = v;
	}
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setAccelerator
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setAccelerator
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkRadioActionEntry*)entry)->accelerator = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkRadioActionEntry*)entry)->accelerator = v;
	}
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setToolTip
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setToolTip
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkRadioActionEntry*)entry)->tooltip = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkRadioActionEntry*)entry)->tooltip = v;
	}
}

/*
 * Class:     org_gnu_gtk_RadioActionEntry
 * Method:    setValue
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioActionEntry_setValue
  (JNIEnv *env, jclass cls, jint entry, jint value)
{
	((GtkRadioActionEntry*)entry)->value = value;
}

#ifdef __cplusplus
}
#endif
#endif
