/* rygel-dlna-available-seek-request.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-dlna-available-seek-request.vala, do not modify */

/*
 * Copyright (C) 2014  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST (rygel_dlna_available_seek_range_request_get_type ())
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST, RygelDLNAAvailableSeekRangeRequest))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST, RygelDLNAAvailableSeekRangeRequestClass))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST, RygelDLNAAvailableSeekRangeRequestClass))

typedef struct _RygelDLNAAvailableSeekRangeRequest RygelDLNAAvailableSeekRangeRequest;
typedef struct _RygelDLNAAvailableSeekRangeRequestClass RygelDLNAAvailableSeekRangeRequestClass;
typedef struct _RygelDLNAAvailableSeekRangeRequestPrivate RygelDLNAAvailableSeekRangeRequestPrivate;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelDLNAAvailableSeekRangeRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelDLNAAvailableSeekRangeRequestPrivate * priv;
};

struct _RygelDLNAAvailableSeekRangeRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()

static gpointer rygel_dlna_available_seek_range_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_dlna_available_seek_range_request_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_DUMMY_PROPERTY
};
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_AVAILABLE_SEEK_RANGE_HEADER "getAvailableSeekRange.dlna.org"
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelDLNAAvailableSeekRangeRequest* rygel_dlna_available_seek_range_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, GError** error);
RygelDLNAAvailableSeekRangeRequest* rygel_dlna_available_seek_range_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gboolean rygel_dlna_available_seek_range_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler);
gboolean rygel_dlna_available_seek_range_request_requested (SoupMessage* message);


/**
     * Create a DLNAAvailableSeekRangeRequest corresponding with a HTTPGet
     * that contains a getAvailableSeekRange.dlna.org header value.
     *
     * @param request The HTTP GET/HEAD request
     */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


RygelDLNAAvailableSeekRangeRequest* rygel_dlna_available_seek_range_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, GError** error) {
	RygelDLNAAvailableSeekRangeRequest * self = NULL;
	gchar* params = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelDLNAAvailableSeekRangeRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_AVAILABLE_SEEK_RANGE_HEADER);
	_tmp3_ = g_strdup (_tmp2_);
	params = _tmp3_;
	_tmp4_ = params;
	if (_tmp4_ == NULL) {
		GError* _tmp5_ = NULL;
		_tmp5_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST, "%s not present", RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_AVAILABLE_SEEK_RANGE_HEADER);
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (params);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (params);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = params;
	_tmp7_ = string_strip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp8_, "1") != 0;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp10_ = params;
		_tmp11_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST, "%s != 1 (found \"%s\")", RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_AVAILABLE_SEEK_RANGE_HEADER, _tmp10_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (params);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (params);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (params);
	return self;
}


RygelDLNAAvailableSeekRangeRequest* rygel_dlna_available_seek_range_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, GError** error) {
	return rygel_dlna_available_seek_range_request_construct (RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_REQUEST, message, handler, error);
}


/**
     * Return true if getAvailableSeekRange is supported.
     */
gboolean rygel_dlna_available_seek_range_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler) {
	gboolean result = FALSE;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	result = TRUE;
	return result;
}


/**
     * Return true of the HTTPGet contains a getAvailableSeekRange request.
     */
gboolean rygel_dlna_available_seek_range_request_requested (SoupMessage* message) {
	gboolean result = FALSE;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_DLNA_AVAILABLE_SEEK_RANGE_REQUEST_GET_AVAILABLE_SEEK_RANGE_HEADER);
	result = _tmp2_ != NULL;
	return result;
}


static void rygel_dlna_available_seek_range_request_class_init (RygelDLNAAvailableSeekRangeRequestClass * klass) {
	rygel_dlna_available_seek_range_request_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_dlna_available_seek_range_request_instance_init (RygelDLNAAvailableSeekRangeRequest * self) {
}


/**
 * This class represents a DLNA getAvailableSeekRange request.
 *
 * A getAvailableSeekRange request can only have a single parameter: "1"
 */
GType rygel_dlna_available_seek_range_request_get_type (void) {
	static volatile gsize rygel_dlna_available_seek_range_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dlna_available_seek_range_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDLNAAvailableSeekRangeRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dlna_available_seek_range_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDLNAAvailableSeekRangeRequest), 0, (GInstanceInitFunc) rygel_dlna_available_seek_range_request_instance_init, NULL };
		GType rygel_dlna_available_seek_range_request_type_id;
		rygel_dlna_available_seek_range_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDLNAAvailableSeekRangeRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dlna_available_seek_range_request_type_id__volatile, rygel_dlna_available_seek_range_request_type_id);
	}
	return rygel_dlna_available_seek_range_request_type_id__volatile;
}



