/*
 * @(#)Skewb2dP.h
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Skewb2d */

#ifndef _Skewb2dP_h
#define _Skewb2dP_h

#include "Skewb2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Skewb2DClassPart {
	int ignore;
} Skewb2DClassPart;

typedef struct _Skewb2DClassRec {
	CoreClassPart coreClass;
	SkewbClassPart skewbClass;
	Skewb2DClassPart skewb2dClass;
} Skewb2DClassRec;

extern Skewb2DClassRec skewb2dClassRec;
#endif

#define FRONT_LOC 0
#define BACK_LOC 11
#define COORD2D 8
#define MAXX 3
#define MAXY 4
#define MAXXY 4			/* (MAX(MAXX,MAXY)) */
#define MAX_RECT (MAXX*MAXY)

typedef struct _Skewb2DPart {
	Position    faceLength;
	Position    viewLength;
	Position    diamondLength;
} Skewb2DPart;

typedef struct _Skewb2DRec {
	CorePart    core;
	SkewbPart   skewb;
	Skewb2DPart skewb2d;
} Skewb2DRec;

extern Boolean selectPieces2D(Skewb2DWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelection2D(Skewb2DWidget w,
	int *face, int *position, int *direction);
extern void drawFrame2D(Skewb2DWidget w, Boolean focus);
extern void drawDiamond2D(Skewb2DWidget w, int face, int offset);
extern void drawTriangle2D(Skewb2DWidget w, int face, int position,
	int offset);
#ifdef WINVER
extern void initializePuzzle2D(Skewb2DWidget w);
extern void resizePuzzle2D(Skewb2DWidget w);
extern void exposePuzzle2D(Skewb2DWidget w);
#endif

#endif /* _Skewb2dP_h */
