# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementDevicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_list_by_subscription(self, resource_group):
        response = self.client.devices.list_by_subscription(
            api_version="2021-02-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_list_by_resource_group(self, resource_group):
        response = self.client.devices.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_get(self, resource_group):
        response = self.client.devices.get(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_create_or_update(self, resource_group):
        response = self.client.devices.begin_create_or_update(
            device_name="str",
            resource_group_name=resource_group.name,
            data_box_edge_device={
                "location": "str",
                "configuredRoleTypes": ["str"],
                "culture": "str",
                "dataBoxEdgeDeviceStatus": "str",
                "description": "str",
                "deviceHcsVersion": "str",
                "deviceLocalCapacity": 0,
                "deviceModel": "str",
                "deviceSoftwareVersion": "str",
                "deviceType": "str",
                "edgeProfile": {
                    "subscription": {
                        "id": "str",
                        "locationPlacementId": "str",
                        "quotaId": "str",
                        "registeredFeatures": [{"name": "str", "state": "str"}],
                        "registrationDate": "str",
                        "registrationId": "str",
                        "serializedDetails": "str",
                        "state": "str",
                        "subscriptionId": "str",
                        "tenantId": "str",
                    }
                },
                "etag": "str",
                "friendlyName": "str",
                "id": "str",
                "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                "kind": "str",
                "modelDescription": "str",
                "name": "str",
                "nodeCount": 0,
                "resourceMoveDetails": {
                    "operationInProgress": "str",
                    "operationInProgressLockTimeoutInUTC": "2020-02-20 00:00:00",
                },
                "serialNumber": "str",
                "sku": {"name": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "timeZone": "str",
                "type": "str",
            },
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_delete(self, resource_group):
        response = self.client.devices.begin_delete(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_update(self, resource_group):
        response = self.client.devices.update(
            device_name="str",
            resource_group_name=resource_group.name,
            parameters={
                "edgeProfile": {"subscription": {"id": "str"}},
                "identity": {"principalId": "str", "tenantId": "str", "type": "str"},
                "tags": {"str": "str"},
            },
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_download_updates(self, resource_group):
        response = self.client.devices.begin_download_updates(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_generate_certificate(self, resource_group):
        response = self.client.devices.generate_certificate(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_get_extended_information(self, resource_group):
        response = self.client.devices.get_extended_information(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_install_updates(self, resource_group):
        response = self.client.devices.begin_install_updates(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_get_network_settings(self, resource_group):
        response = self.client.devices.get_network_settings(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_scan_for_updates(self, resource_group):
        response = self.client.devices.begin_scan_for_updates(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_begin_create_or_update_security_settings(self, resource_group):
        response = self.client.devices.begin_create_or_update_security_settings(
            device_name="str",
            resource_group_name=resource_group.name,
            security_settings={
                "deviceAdminPassword": {
                    "encryptionAlgorithm": "str",
                    "value": "str",
                    "encryptionCertThumbprint": "str",
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_update_extended_information(self, resource_group):
        response = self.client.devices.update_extended_information(
            device_name="str",
            resource_group_name=resource_group.name,
            parameters={
                "channelIntegrityKeyName": "str",
                "channelIntegrityKeyVersion": "str",
                "clientSecretStoreId": "str",
                "clientSecretStoreUrl": "str",
                "syncStatus": "str",
            },
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_get_update_summary(self, resource_group):
        response = self.client.devices.get_update_summary(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_devices_upload_certificate(self, resource_group):
        response = self.client.devices.upload_certificate(
            device_name="str",
            resource_group_name=resource_group.name,
            parameters={"certificate": "str", "authenticationType": "str"},
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...
