/*
 *  Entangle: Tethered Camera Control & Capture
 *
 *  Copyright (C) 2009-2018 Daniel P. Berrangé
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdio.h>

#include "entangle-control-button.h"

#include "entangle-debug.h"

/**
 * SECTION:entangle-control-button
 * @Short_description: a device control that is a simple button
 * @Title: EntangleControlButton
 *
 * The #EntangleControlButton object provides a device control
 * that acts like a momentary push button.
 */

struct _EntangleControlButton
{
    EntangleControl parent;
};

G_DEFINE_TYPE(EntangleControlButton,
              entangle_control_button,
              ENTANGLE_TYPE_CONTROL);

static void
entangle_control_button_finalize(GObject *object)
{
    G_OBJECT_CLASS(entangle_control_button_parent_class)->finalize(object);
}

static void
entangle_control_button_class_init(EntangleControlButtonClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);

    object_class->finalize = entangle_control_button_finalize;
}

EntangleControlButton *
entangle_control_button_new(const char *path,
                            int id,
                            const char *label,
                            const char *info,
                            gboolean readonly)
{
    g_return_val_if_fail(path != NULL, NULL);
    g_return_val_if_fail(label != NULL, NULL);

    return ENTANGLE_CONTROL_BUTTON(
        g_object_new(ENTANGLE_TYPE_CONTROL_BUTTON, "path", path, "id", id,
                     "label", label, "info", info, "readonly", readonly, NULL));
}

static void
entangle_control_button_init(EntangleControlButton *control G_GNUC_UNUSED)
{}

/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  indent-tabs-mode: nil
 *  tab-width: 8
 * End:
 */
