@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-ectrans-list: List all ECtrans transfers
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );
my $ectransId = $ARGV[0];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

if ( not($ectransId) ) {

	# Get the list of transfers
	my $transfers = $controlChannel->getTransferList($token);

	# Display the information for each transfer
	foreach $transfer ( $transfers->valueof('//getTransferListResponse/return') ) {
		printf "%-10s %-10s %-20s %-20s %s\n", $transfer->{transferId}, $transfer->{status}, $transfer->{ownerUserId}, $transfer->{hostName},
		  $transfer->{scheduledDate};
	}
}
else {

	# Get the detail for the specified ectransId
	my $transfer = $controlChannel->getTransfer( $token, $ectransId )->valueof('//getTransferResponse/return');
	print "    Copyid: " . $transfer->{transferId} . "\n";
	print "   MS user: " . $transfer->{ownerUserId} . "\n";
	print "  Hostname: " . $transfer->{hostName} . "\n";
	print "    Status: " . $transfer->{status} . "\n";
	print "Last error: " . $transfer->{lastErrorMessage} . "\n" if ( $transfer->{lastErrorMessage} );
	print "  Schedule: " . $transfer->{scheduledDate} . "\n";
	print "    Source: " . $transfer->{sourceFileName} . "\n";
	print "    Target: " . $transfer->{targetFileName} . "\n";
	print " File size: " . $transfer->{fileSize} . "\n";
}

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-ectrans-list - List all ECtrans transfers

=head1 SYNOPSIS

B<ecaccess-ectrans-list -version|-help|-manual>

B<ecaccess-ectrans-list [-debug] [>I<ectrans-id>B<]>

=head1 DESCRIPTION

List all the ECtrans transfers in the ECtrans Spool. When an I<ectrans-id> is specified then
the details for this transfer are displayed.

The Transfer statuses can have the following values:

=over 8

=item B<INIT>

Files are being transferred to the spool.

=item B<COPY>

Files are being transferred to the remote site.

=item B<WAIT>

Files are scheduled and waiting to be started.

=item B<RETR>

File transfer will be retried.

=item B<STOP>

Files have NOT been successfully transferred (error).

=item B<DONE>

Files have been successfully transferred.

=back

=head1 ARGUMENTS

=over 8

=item I<ectrans-id> (optional)

The name of the ECtrans transfer to retrieve the details.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-ectrans-list> I<124356>

Give the informations concerning the ECtrans transfer I<124356>.

B<ecaccess-ectrans-list>

List all the ECtrans transfers in the Spool.

=head1 SEE ALSO

B<ecaccess-ectrans-delete>, B<ecaccess-ectrans-request>, B<ecaccess-ectrans-restart> and B<ecaccess>.

=cut

__END__
:endofperl
