/*
  DB Mixer
  ========
  Description: 
    a DJ Mixer style GUI interface to the DBMix system.

	Copyright (c) 1999, 2000 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <gtk/gtk.h>
#include <dbchannel.h>

#define DBMIXER_VERSION_STR "DBMixer v 0.9.8"

#ifdef DBMIX_DEBUG
#define MASTER_MIXER    "/dev/mixer0"
#define CUE_MIXER       "/dev/mixer1"
#else
#define MASTER_MIXER    "/dev/mixer"
#define CUE_MIXER       "/dev/mixer1"
#endif

#define CHANNEL_STR     "Input:"
#define MUTE_STR        "Mute"
#define CUE_STR         "CUE"
#define PAUSE_STR       "Pause"
#define GAIN_STR        "Level"
#define PITCH_STR       "Pitch"
#define UPDATE_STR      "Update Settings"
#define RESET_STR       "Reset Soundcard"
#define PUNCH_STR       "Punch"
#define PREFERENCES_STR "Preferences"
#define OPTION_STR      "Options"
#define ABOUT_STR       "About"
#define QUIT_STR        "Quit"
#define RESET_PITCH_STR "-|-"
#define PITCH_PLUS5_STR "5>"
#define PITCH_MINUS5_STR "<5"
#define AUTOFADE_STR     "Autofade Spd."
#define MASTER_LEVEL_STR "Main"
#define CUE_LEVEL_STR    "Cue" 
#define BALANCE_STR      "L - Balance - R"
#define CUE_SPLIT_STR    "Cue Split"
#define TALKOVER_STR     "Mic Talkover"
#define SOUNDCARD_FRAME_STR "Soundcard Settings"
#define TUNE_STR         "DBMix Tuning"
#define RECORD_STR       "Record Sample"
#define PLAYSINGLE_STR   "Once"
#define PLAYLOOP_STR     "Loop"
#define SAMPLER_STR      "Sample Editor"
#define SYNC_PLUS        "S+"
#define SYNC_MINUS       "-S"
#define SYNC_PAUSE       ".]S[."
#define COPY_SAMPLE_STR  "Copy Sample To:"
#define LOAD_SAMPLE_STR  " Load "
#define SAVE_SAMPLE_STR  " Save "
#define RECORD_WAV_STR   "Record Session"
#define STOP_WAV_STR     "Stop Recording Session"

#define NO_CLIENT_STR    "\n\tNo client for selected channel.\t\n"
#define SAMPLE_FILE_STR  "Please select a dbmix sample file:"

#define CLIPPING_INTERVAL 200

#define UPDATE_CHANNEL_TIMEOUT  1000

#define PITCH_LOW_BOUND   85.0
#define PITCH_HIGH_BOUND  115.0

#define DEFAULT_FADE_TIME_BASE  6
#define FADE_TIME_MAX 15

#define PITCH_SYNC_VALUE 8

#define USLEEP_TIME 30

/* define minimum loop size to be a little over the length of 2 * PIPE_BUF */
#define MIN_LOOP_SECONDS     (0.05)

void init(void);
void cleanup(void);
void db_message_box(gchar *message);
void send_msg(local_channel * lch,long int  msg_type, float data);
void dbmixer_about(void);
gint dbmixer_exit(GtkWidget * window, GdkEventAny * e, gpointer data);
gint normalize_scale(gint i);
GtkWidget* make_channel_menu(int ch_id);
GtkWidget *make_menu_item(gchar *name, GtkSignalFunc callback,gpointer data );
int Channel_Init(); 

GtkWidget * create_channel_controls(int ch_id);
GtkWidget* Create_Soundcard_Controls();

/* Used to update the channel volume correctly */ 
void crossfader_scale_changed( GtkAdjustment *);

int Soundcard_Mixer_Init();

GtkWidget* make_channel_menu(int ch_id);
int update_channels(gpointer data);
int update_soundcards(gpointer data);
void update_fader1();
void update_fader2();
int update_balance(gpointer data);

GtkWidget* Create_Fader();

void * monitor_loop(void * arg);

GtkWidget * Create_Clipping_Light(GtkWidget * w);
void Clipping_Light_Toggle(gint flag);
int clipping_light_callback(gpointer * data);
void Create_Autofade_Scale(GtkBox * box);

int Cue_Enabled(local_channel * ch);

GtkWidget * create_sample_editor();
int update_sampler(gpointer data);

typedef struct channel_select_data_s
{
	int index;
	int channel;
} channel_select_data;

/* structure to hold pointers to all widgets */
typedef struct channel_widgets_s
{
	GtkAdjustment    * adj;
	GtkAdjustment    * pitch_adj;
	GtkVScale        * level_scale;
	GtkHScale        * pitch_scale;
	GtkToggleButton  * mute_button;
	GtkToggleButton  * cue_button;
	GtkButton        * playsingle_button;
	GtkToggleButton  * playloop_button;
	GtkToggleButton  * pause_button;
	GtkButton        * punch_button;
	GtkButton        * reset_pitch_button;
	GtkButton        * pitch_plus5_button;
	GtkButton        * pitch_minus5_button;
	GtkButton        * pitch_sync_plus_button;
	GtkButton        * pitch_sync_pause_button;
	GtkButton        * pitch_sync_minus_button;
	GtkWidget        * opt;
	GSList           * datalist;
	gint               ch_id;
	gint               tempvol;
} channel_widgets;
