
/*
 * Copyright (C) Yichun Zhang (agentzh)
 */


#ifndef DDEBUG
#define DDEBUG 0
#endif
#include "ddebug.h"


#if (NGX_HTTP_SSL)


int ngx_http_lua_ssl_ctx_index = -1;
int ngx_http_lua_ssl_key_log_index = -1;


ngx_int_t
ngx_http_lua_ssl_init(ngx_log_t *log)
{
    if (ngx_http_lua_ssl_ctx_index == -1) {
        ngx_http_lua_ssl_ctx_index = SSL_get_ex_new_index(0, NULL, NULL,
                                                          NULL, NULL);

        if (ngx_http_lua_ssl_ctx_index == -1) {
            ngx_ssl_error(NGX_LOG_ALERT, log, 0,
                          "lua: SSL_get_ex_new_index() for ctx failed");
            return NGX_ERROR;
        }
    }

    if (ngx_http_lua_ssl_key_log_index == -1) {
        ngx_http_lua_ssl_key_log_index = SSL_get_ex_new_index(0, NULL, NULL,
                                                              NULL, NULL);

        if (ngx_http_lua_ssl_key_log_index == -1) {
            ngx_ssl_error(NGX_LOG_ALERT, log, 0,
                          "lua: SSL_get_ex_new_index() for key log failed");
            return NGX_ERROR;
        }
    }

    return NGX_OK;
}


#endif /* NGX_HTTP_SSL */
