/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.zookeeper;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooKeeperTestable implements Testable {

    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperTestable.class);

    private final ClientCnxn clientCnxn;

    ZooKeeperTestable(ClientCnxn clientCnxn) {
        this.clientCnxn = clientCnxn;
    }

    @Override
    public void injectSessionExpiration() {
        LOG.info("injectSessionExpiration() called");

        clientCnxn.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        clientCnxn.eventThread.queueEventOfDeath();
        clientCnxn.state = ZooKeeper.States.CLOSED;
        clientCnxn.sendThread.getClientCnxnSocket().onClosing();
    }

    @Override
    public void queueEvent(WatchedEvent event) {
        LOG.info("queueEvent() called: {}", event);
        clientCnxn.eventThread.queueEvent(event);
    }

    @Override
    public void closeSocket() throws IOException {
        LOG.info("closeSocket() called");
        clientCnxn.sendThread.testableCloseSocket();
    }

}
