/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebPage;

/**
 * Test page for triggering the component is not on page error from AjaxRequestHandler.
 */
public class ComponentNotOnPage extends WebPage
{
	private static final long serialVersionUID = 1L;
	
	private Component notOnPage;
	
	public ComponentNotOnPage(Component notOnPage) {
		this.notOnPage = notOnPage;
		
		notOnPage.setOutputMarkupId(true);
	}

	@Override
	protected void onInitialize()
	{
		super.onInitialize();

		add(new AjaxLink<Void>("refresher") {
			@Override
			public void onClick(AjaxRequestTarget target) {
				target.add(notOnPage);
			}
		});
	}
}
