/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.util;

import java.util.concurrent.TimeUnit;

public class CachedValue<T> {
    private long ttl;
    private long date;
    private T value;

    public CachedValue(long value, TimeUnit unit) {
        this.ttl = TimeUnit.MILLISECONDS.convert(value, unit);
    }

    public boolean isStaled() {
        return System.currentTimeMillis() - this.date > this.ttl;
    }

    public synchronized void setValue(T value) {
        this.date = System.currentTimeMillis();
        this.value = value;
    }

    public synchronized T getValue() {
        return this.isStaled() ? null : (T)this.value;
    }
}

