/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import org.apache.uima.internal.util.TimeSpan;

public final class Timer {
    private long time = 0L;
    private long start = 0L;
    private boolean isRunning = false;

    public boolean start() {
        if (this.isRunning) {
            return false;
        }
        this.isRunning = true;
        this.start = System.currentTimeMillis();
        return true;
    }

    public boolean stop() {
        long end = System.currentTimeMillis();
        if (!this.isRunning) {
            return false;
        }
        this.isRunning = false;
        this.time += end - this.start;
        return true;
    }

    public boolean reset() {
        if (this.isRunning) {
            return false;
        }
        this.time = 0L;
        return true;
    }

    public long getTime() {
        if (this.isRunning) {
            this.stop();
            long rt = this.time;
            this.start();
            return rt;
        }
        return this.time;
    }

    public TimeSpan getTimeSpan() {
        return new TimeSpan(this.getTime());
    }
}

