/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.function.IntConsumer_withIOException;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.EmptyList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.json.impl.JsonContentHandlerJacksonWrapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JsonCasSerializer {
    private static final SerializedString CONTEXT_NAME = new SerializedString("_context");
    private static final SerializedString TYPE_SYSTEM_NAME = new SerializedString("_type_system");
    private static final SerializedString TYPES_NAME = new SerializedString("_types");
    private static final SerializedString ID_NAME = new SerializedString("_id");
    private static final SerializedString SUB_TYPES_NAME = new SerializedString("_subtypes");
    private static final SerializedString FEATURE_TYPES_NAME = new SerializedString("_feature_types");
    private static final SerializedString FEATURE_REFS_NAME = new SerializedString("_ref");
    private static final SerializedString FEATURE_ARRAY_NAME = new SerializedString("_array");
    private static final SerializedString FEATURE_BYTE_ARRAY_NAME = new SerializedString("_byte_array");
    private static final SerializedString REFERENCED_FSS_NAME = new SerializedString("_referenced_fss");
    private static final SerializedString VIEWS_NAME = new SerializedString("_views");
    private static final SerializedString TYPE_NAME = new SerializedString("_type");
    private static final SerializedString COLLECTION_NAME = new SerializedString("_collection");
    private static final SerializedString DELTA_CAS_NAME = new SerializedString("_delta_cas");
    private static final SerializedString ADDED_MEMBERS_NAME = new SerializedString("added_members");
    private static final SerializedString DELETED_MEMBERS_NAME = new SerializedString("deleted_members");
    private static final SerializedString REINDEXED_MEMBERS_NAME = new SerializedString("reindexed_members");
    private final CasSerializerSupport css = new CasSerializerSupport();
    private JsonFactory jsonFactory = null;
    private boolean isDynamicEmbedding = true;
    private boolean isWithContext = true;
    private boolean isWithSubtypes = true;
    private boolean isWithExpandedTypeNames = true;
    private boolean isOmit0Values = false;
    private String typeSystemReference;

    CasSerializerSupport getCss() {
        return this.css;
    }

    public static void jsonSerialize(CAS aCAS, Object output) throws IOException {
        JsonCasSerializer.jsonSerialize(aCAS, null, output, false, null, null);
    }

    public static void jsonSerialize(CAS aCAS, TypeSystem aTargetTypeSystem, Object output) throws IOException {
        JsonCasSerializer.jsonSerialize(aCAS, aTargetTypeSystem, output, false, null, null);
    }

    public static void jsonSerialize(CAS aCAS, TypeSystem aTargetTypeSystem, Object output, boolean aPrettyPrint, Marker aMarker, XmiSerializationSharedData sharedData) throws IOException {
        JsonCasSerializer ser = new JsonCasSerializer();
        ser.setFilterTypes((TypeSystemImpl)aTargetTypeSystem);
        ser.setPrettyPrint(aPrettyPrint);
        ser.serialize(aCAS, output, sharedData, aMarker);
    }

    public void serialize(CAS cas, Object output) throws IOException {
        this.serialize(cas, output, null, null);
    }

    public void serialize(CAS cas, Object output, XmiSerializationSharedData sharedData, Marker marker) throws IOException {
        JsonContentHandlerJacksonWrapper jch;
        try {
            jch = new JsonContentHandlerJacksonWrapper(this.jsonFactory, output, this.css.isFormattedOutput);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        this.serialize(cas, jch, sharedData, marker);
    }

    public void serialize(CAS cas, JsonContentHandlerJacksonWrapper jch) throws IOException {
        this.serialize(cas, jch, null, null);
    }

    public void serialize(CAS cas, JsonContentHandlerJacksonWrapper jch, XmiSerializationSharedData sharedData, Marker marker) throws IOException {
        JsonDocSerializer ser = new JsonDocSerializer(jch, ((CASImpl)cas).getBaseCAS(), sharedData, (MarkerImpl)marker);
        try {
            ser.cds.needNameSpaces = false;
            ser.cds.serialize();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public JsonCasSerializer setPrettyPrint(boolean pp) {
        this.css.setPrettyPrint(pp);
        return this;
    }

    public JsonCasSerializer setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
        return this;
    }

    public JsonCasSerializer setFilterTypes(TypeSystemImpl ts) {
        this.css.setFilterTypes(ts);
        return this;
    }

    public JsonCasSerializer setTypeSystemReference(String reference) {
        this.typeSystemReference = reference;
        return this;
    }

    public JsonCasSerializer setErrorHandler(ErrorHandler eh) {
        this.css.setErrorHandler(eh);
        return this;
    }

    public JsonCasSerializer setStaticEmbedding() {
        this.isDynamicEmbedding = false;
        return this;
    }

    public JsonCasSerializer setJsonContext(JsonContextFormat format) {
        switch (format) {
            case omitContext: {
                this.isWithContext = false;
                this.isWithSubtypes = false;
                this.isWithExpandedTypeNames = false;
                break;
            }
            case omitSubtypes: {
                this.isWithSubtypes = false;
                break;
            }
            case omitExpandedTypeNames: {
                this.isWithExpandedTypeNames = false;
            }
        }
        return this;
    }

    public JsonCasSerializer setOmit0Values(boolean omitDefaultValues) {
        this.isOmit0Values = omitDefaultValues;
        return this;
    }

    class JsonDocSerializer
    extends CasSerializerSupport.CasSerializerSupportSerialize {
        private final CasSerializerSupport.CasDocSerializer cds;
        private final JsonContentHandlerJacksonWrapper jch;
        private final JsonGenerator jg;
        private final Map<String, SerializedString> serializedStrings = new HashMap<String, SerializedString>();
        private final Map<String, XmlElementName> usedTypeName2XmlElementName;
        private final MapType2Subtypes mapType2Subtypes = new MapType2Subtypes();
        private final List<TypeImpl> parentTypesWithNoInstances = new ArrayList<TypeImpl>();
        private int lastEncodedTypeCode;
        private boolean startedReferencedFSs;
        private final boolean isOmitDefaultValues;
        private final boolean isWithContext;
        private final boolean isWithSubtypes;
        private boolean indexId;
        private boolean isEmbedded = false;
        private boolean isEmbeddedFromFsFeature;
        private boolean startedFeatureTypes;

        private JsonDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker) {
            CasSerializerSupport casSerializerSupport = JsonCasSerializer.this.css;
            Objects.requireNonNull(casSerializerSupport);
            this.cds = new CasSerializerSupport.CasDocSerializer(casSerializerSupport, ch, cas, sharedData, marker, (CasSerializerSupport.CasSerializerSupportSerialize)this, JsonCasSerializer.this.isDynamicEmbedding);
            this.isOmitDefaultValues = JsonCasSerializer.this.isOmit0Values;
            this.isWithSubtypes = JsonCasSerializer.this.isWithSubtypes;
            this.jch = (JsonContentHandlerJacksonWrapper)ch;
            this.jg = this.jch.getJsonGenerator();
            this.isWithContext = JsonCasSerializer.this.isWithContext || this.isWithSubtypes || JsonCasSerializer.this.isWithExpandedTypeNames;
            this.usedTypeName2XmlElementName = new HashMap<String, XmlElementName>(this.cds.tsi.getNumberOfTypes());
        }

        protected void initializeNamespaces() {
            if (this.cds.sharedData != null && (null != this.cds.sharedData.getOutOfTypeSystemElements() || this.cds.sharedData.hasOutOfTypeSystemArrayElements())) {
                throw new UnsupportedOperationException("Can't do JSON serialization if there are out-of-type-system elements, because there's no type information available (needed for _context)");
            }
        }

        protected void writeViews() throws Exception {
            if (!this.cds.isDelta) {
                return;
            }
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName((SerializableString)DELTA_CAS_NAME);
            this.jg.writeStartObject();
            this.cds.writeViewsCommons();
            this.jg.writeEndObject();
        }

        protected void writeFeatureStructures(int elementCount) throws Exception {
            this.jch.withoutNl();
            this.jg.writeStartObject();
            if (this.isWithContext) {
                this.serializeJsonLdContext();
            }
            this.jch.writeNlJustBeforeNext();
            this.indexId = false;
            this.jg.writeFieldName((SerializableString)VIEWS_NAME);
            this.jg.writeStartObject();
            List<TOP>[] byViewByTypeFSs = this.sortByViewType();
            for (int viewNbr = 1; viewNbr <= byViewByTypeFSs.length; ++viewNbr) {
                this.lastEncodedTypeCode = -1;
                List<TOP> fssInView = byViewByTypeFSs[viewNbr - 1];
                Sofa sofa = this.cds.getSofa(viewNbr);
                if (sofa == null && fssInView.size() == 0) continue;
                this.jch.writeNlJustBeforeNext();
                String viewName = null == sofa ? "_InitialView" : sofa.getSofaID();
                this.jg.writeFieldName(viewName);
                this.jg.writeStartObject();
                for (TOP fs : fssInView) {
                    this.cds.encodeFS(fs);
                }
                if (this.lastEncodedTypeCode != -1) {
                    this.jg.writeEndArray();
                }
                this.jg.writeEndObject();
            }
            this.jg.writeEndObject();
            this.indexId = true;
            this.startedReferencedFSs = false;
            this.cds.encodeQueued();
            if (this.startedReferencedFSs) {
                this.jg.writeEndObject();
            }
        }

        protected void writeEndOfSerialization() throws IOException {
            this.jg.writeEndObject();
            this.jg.flush();
        }

        private List<TOP>[] sortByViewType() {
            List[] r = new List[this.cds.indexedFSs.length];
            int i = 0;
            for (List fss : this.cds.indexedFSs) {
                r[i] = fss == null ? Collections.EMPTY_LIST : (List)((ArrayList)fss).clone();
                r[i++].sort(this.cds.sortFssByType);
            }
            return r;
        }

        protected void writeView(Sofa sofa, Collection<TOP> members) throws IOException {
            this.jch.writeNlJustBeforeNext();
            String sofaXmiId = null == sofa ? "0" : this.cds.getXmiId((TOP)sofa);
            this.jg.writeArrayFieldStart(sofaXmiId);
            this.writeViewMembers(members);
            if (this.cds.sharedData != null) {
                List ootsMembers = this.cds.sharedData.getOutOfTypeSystemViewMembers(sofaXmiId);
                this.jch.writeNlJustBeforeNext();
                this.writeViewMembers(ootsMembers);
            }
            this.jg.writeEndArray();
        }

        private void writeViewForDeltas(SerializedString kind, Collection<TOP> deltaMembers) throws IOException {
            this.jg.writeFieldName((SerializableString)kind);
            this.jg.writeStartArray();
            this.writeViewMembers(deltaMembers);
            this.jg.writeEndArray();
        }

        protected void writeView(Sofa sofa, Collection<TOP> added, Collection<TOP> deleted, Collection<TOP> reindexed) throws IOException {
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName(this.cds.getXmiId((TOP)sofa));
            this.jg.writeStartObject();
            this.writeViewForDeltas(ADDED_MEMBERS_NAME, added);
            this.writeViewForDeltas(DELETED_MEMBERS_NAME, deleted);
            this.writeViewForDeltas(REINDEXED_MEMBERS_NAME, reindexed);
            this.jg.writeEndObject();
        }

        private void writeViewMembers(Collection<TOP> members) throws IOException {
            int nextBreak = CasSerializerSupport.PP_ELEMENTS;
            int i = 0;
            for (TOP member : members) {
                int xmiId = this.cds.getXmiIdAsInt(member);
                if (xmiId == 0) continue;
                if (i++ > nextBreak) {
                    this.jch.writeNlJustBeforeNext();
                    nextBreak += CasSerializerSupport.PP_ELEMENTS;
                }
                this.jg.writeNumber(xmiId);
            }
        }

        private void writeViewMembers(List<String> members) throws IOException {
            int nextBreak = CasSerializerSupport.PP_ELEMENTS;
            int i = 0;
            for (String xmiId : members) {
                if (null == xmiId || xmiId.length() == 0) continue;
                if (i++ > nextBreak) {
                    this.jch.writeNlJustBeforeNext();
                    nextBreak += CasSerializerSupport.PP_ELEMENTS;
                }
                this.jg.writeNumber(Integer.parseInt(xmiId));
            }
        }

        private void serializeJsonLdContext() throws IOException {
            this.jg.writeFieldName((SerializableString)CONTEXT_NAME);
            this.jg.writeStartObject();
            if (JsonCasSerializer.this.typeSystemReference != null) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)TYPE_SYSTEM_NAME);
                this.jg.writeString(JsonCasSerializer.this.typeSystemReference);
            }
            this.collectUsedSubtypes();
            this.jch.writeNlJustBeforeNext();
            this.jg.writeFieldName((SerializableString)TYPES_NAME);
            this.jg.writeStartObject();
            for (TypeImpl ti : this.cds.getSortedUsedTypes()) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(ti));
                this.jg.writeStartObject();
                if (JsonCasSerializer.this.isWithExpandedTypeNames) {
                    this.jg.writeFieldName((SerializableString)ID_NAME);
                    this.jg.writeString(ti.getName());
                }
                this.addJsonFeatContext(ti);
                if (this.isWithSubtypes) {
                    this.addJsonSubtypes(ti);
                }
                this.jg.writeEndObject();
            }
            for (TypeImpl ti : this.parentTypesWithNoInstances) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(ti));
                this.jg.writeStartObject();
                XmlElementName xe = this.cds.typeCode2namespaceNames[ti.getCode()];
                if (JsonCasSerializer.this.isWithExpandedTypeNames) {
                    this.jg.writeFieldName((SerializableString)ID_NAME);
                    this.jg.writeString(xe.nsUri);
                }
                this.addJsonFeatContext(ti);
                if (this.isWithSubtypes) {
                    this.addJsonSubtypes(ti);
                }
                this.jg.writeEndObject();
            }
            this.jg.writeEndObject();
            this.jg.writeEndObject();
        }

        private void addJsonFeatContext(TypeImpl type) throws IOException {
            FeatureImpl[] feats = type.getFeatureImpls();
            this.startedFeatureTypes = false;
            for (FeatureImpl feat : feats) {
                int fsClass = CasSerializerSupport.classifyType((TypeImpl)feat.getRangeImpl());
                SerializedString featKind = this.featureTypeLabel(fsClass);
                if (null == featKind) continue;
                this.maybeDoStartFeatureTypes();
                this.jg.writeFieldName((SerializableString)this.getSerializedString(feat.getShortName()));
                this.jg.writeString((SerializableString)featKind);
            }
            if (this.startedFeatureTypes) {
                this.jg.writeEndObject();
            }
        }

        private void maybeDoStartFeatureTypes() throws IOException {
            if (!this.startedFeatureTypes) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)FEATURE_TYPES_NAME);
                this.jg.writeStartObject();
                this.startedFeatureTypes = true;
            }
        }

        private SerializedString getShortFeatureName(FeatureImpl feat) {
            return this.getSerializedString(feat.getShortName());
        }

        private void addJsonSubtypes(TypeImpl ti) throws IOException {
            IntVector iv = (IntVector)this.mapType2Subtypes.get(ti.getCode());
            if (null != iv && iv.size() > 0) {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)SUB_TYPES_NAME);
                this.jg.writeStartArray();
                TypeSystemImpl tsi = ti.getTypeSystem();
                for (int typeCode : iv.toArray()) {
                    this.jg.writeString((SerializableString)this.getSerializedTypeName(tsi.getTypeForCode(typeCode)));
                }
                this.jg.writeEndArray();
            }
        }

        private void collectUsedSubtypes() {
            TypeImpl[] tiArray;
            block0: for (TypeImpl ti : tiArray = this.cds.getSortedUsedTypes()) {
                int subtypeCode = ti.getCode();
                for (TypeImpl parent = ti.getSuperType(); parent != null; parent = parent.getSuperType()) {
                    boolean wasAdded;
                    int parentCode = parent.getCode();
                    if (Arrays.binarySearch(tiArray, parent, CasSerializerSupport.COMPARATOR_SHORT_TYPENAME) < 0 && !this.parentTypesWithNoInstances.contains(parent)) {
                        this.parentTypesWithNoInstances.add(parent);
                    }
                    if (!(wasAdded = this.mapType2Subtypes.addSubtype(parentCode, subtypeCode))) continue block0;
                    subtypeCode = parentCode;
                }
            }
        }

        private SerializedString getSerializedTypeName(TypeImpl ti) {
            XmlElementName xe = this.cds.typeCode2namespaceNames[ti.getCode()];
            if (null == xe) {
                String typeName = ti.getName();
                xe = this.uimaTypeName2XmiElementName(typeName);
                this.checkForNameCollision(xe);
                this.cds.typeCode2namespaceNames[ti.getCode()] = xe;
            }
            return this.getSerializedString(xe.qName);
        }

        private SerializedString getSerializedString(String s) {
            SerializedString ss = this.serializedStrings.get(s);
            if (ss == null) {
                ss = new SerializedString(s);
                this.serializedStrings.put(s, ss);
            }
            return ss;
        }

        protected void checkForNameCollision(XmlElementName xmlElementName) {
            XmlElementName xel = this.usedTypeName2XmlElementName.get(xmlElementName.localName);
            if (xel != null) {
                if (xel.nsUri.equals(xmlElementName.nsUri)) {
                    return;
                }
                this.addNameSpace(xel);
                this.addNameSpace(xmlElementName);
                return;
            }
            this.usedTypeName2XmlElementName.put(xmlElementName.localName, xmlElementName);
        }

        protected boolean writeFsStart(TOP fs, int typeCode) throws IOException {
            if (this.isEmbedded) {
                if (!this.isEmbeddedFromFsFeature) {
                    this.jch.writeNlJustBeforeNext();
                }
                this.jg.writeStartObject();
            } else if (this.indexId) {
                if (!this.startedReferencedFSs) {
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeFieldName((SerializableString)REFERENCED_FSS_NAME);
                    this.jg.writeStartObject();
                    this.startedReferencedFSs = true;
                }
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName(this.cds.getXmiId(fs));
                this.jg.writeStartObject();
            } else {
                if (typeCode != this.lastEncodedTypeCode) {
                    if (this.lastEncodedTypeCode != -1) {
                        this.jg.writeEndArray();
                    }
                    this.lastEncodedTypeCode = typeCode;
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeFieldName((SerializableString)this.getSerializedTypeName(fs._getTypeImpl()));
                    this.jg.writeStartArray();
                }
                if (!this.cds.isDynamicMultiRef || !this.cds.multiRefFSs.contains(fs)) {
                    this.jch.writeNlJustBeforeNext();
                    this.jg.writeStartObject();
                }
            }
            return this.indexId;
        }

        protected void writeFsRef(TOP fs) throws Exception {
            this.jg.writeNumber(this.cds.getXmiIdAsInt(fs));
        }

        private void maybeWriteTypeFeat(TypeImpl ti) throws IOException {
            if (this.indexId || this.isEmbedded) {
                this.jg.writeFieldName((SerializableString)TYPE_NAME);
                this.jg.writeString((SerializableString)this.getSerializedTypeName(ti));
            }
        }

        protected void writeFs(TOP fs, int typeCode) throws IOException {
            this.writeFsOrLists(fs, fs._getTypeImpl(), false);
        }

        protected void writeListsAsIndividualFSs(TOP fs, int typeCode) throws IOException {
            this.writeFsOrLists(fs, fs._getTypeImpl(), true);
        }

        private void writeFsOrLists(TOP fs, TypeImpl ti, boolean isListAsFSs) throws IOException {
            FeatureImpl[] feats = ti.getFeatureImpls();
            this.maybeWriteTypeFeat(ti);
            block13: for (FeatureImpl feat : feats) {
                String fullFeatName;
                if (this.cds.isFiltering && this.cds.filterTypeSystem_inner.getFeatureByFullName(fullFeatName = feat.getName()) == null) continue;
                int featureClass = CasSerializerSupport.classifyType((TypeImpl)feat.getRangeImpl());
                SerializedString shortName = this.getSerializedString(feat.getShortName());
                switch (featureClass) {
                    case 10: {
                        this.writeNumeric(feat, fs._getByteValueNc(feat));
                        continue block13;
                    }
                    case 11: {
                        this.writeNumeric(feat, fs._getShortValueNc(feat));
                        continue block13;
                    }
                    case 1: {
                        this.writeNumeric(feat, fs._getIntValueNc(feat));
                        continue block13;
                    }
                    case 12: {
                        this.writeNumeric(feat, fs._getLongValueNc(feat));
                        continue block13;
                    }
                    case 8: {
                        TOP ref = fs._getFeatureValueNc(feat);
                        if (ref == null) continue block13;
                        this.writeFsOrRef(ref, feat);
                        continue block13;
                    }
                    case 2: {
                        float floatVal = fs._getFloatValueNc(feat);
                        if (floatVal == 0.0f && this.isOmitDefaultValues) continue block13;
                        this.jg.writeFieldName((SerializableString)shortName);
                        this.jg.writeNumber(floatVal);
                        continue block13;
                    }
                    case 13: {
                        double doubleVal = fs._getDoubleValueNc(feat);
                        if (doubleVal == 0.0 && this.isOmitDefaultValues) continue block13;
                        this.jg.writeFieldName((SerializableString)shortName);
                        this.jg.writeNumber(doubleVal);
                        continue block13;
                    }
                    case 9: {
                        this.jg.writeFieldName((SerializableString)shortName);
                        this.jg.writeBoolean(fs._getBooleanValueNc(feat));
                        continue block13;
                    }
                    case 3: {
                        String s = fs._getStringValueNc(feat);
                        if (s == null) continue block13;
                        this.jg.writeFieldName((SerializableString)shortName);
                        this.jg.writeString(s);
                        continue block13;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        this.writeArray(fs, feat, featureClass);
                        continue block13;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        this.writeList(fs, feat, featureClass, isListAsFSs);
                        continue block13;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
        }

        private void writeNumeric(FeatureImpl fi, long v) throws IOException {
            if (v == 0L && this.isOmitDefaultValues) {
                return;
            }
            this.jg.writeFieldName((SerializableString)this.getShortFeatureName(fi));
            this.jg.writeNumber(v);
        }

        private void writeArray(TOP fs, FeatureImpl fi, int featureClass) throws IOException {
            assert (fs != null);
            TOP array = fs._getFeatureValueNc(fi);
            if (array == null) {
                return;
            }
            this.jg.writeFieldName((SerializableString)this.getShortFeatureName(fi));
            if (this.isDynamicOrStaticMultiRef(fi, array)) {
                this.jg.writeNumber(this.cds.getXmiIdAsInt(array));
            } else {
                this.writeJsonArrayValues(array, featureClass);
            }
        }

        private void writeList(TOP fs, FeatureImpl fi, int featureClass, boolean isListAsFSs) throws IOException {
            assert (fs != null);
            TOP list = fs._getFeatureValueNc(fi);
            if (list == null) {
                return;
            }
            this.jg.writeFieldName((SerializableString)this.getShortFeatureName(fi));
            if (this.isDynamicOrStaticMultiRef(fi, list, isListAsFSs)) {
                this.jg.writeNumber(this.cds.getXmiIdAsInt(list));
            } else {
                this.writeJsonListValues(list);
            }
        }

        private void writeFsOrRef(TOP fs) throws IOException {
            if (fs == null || !this.cds.isDynamicMultiRef || this.cds.multiRefFSs.contains(fs)) {
                this.jg.writeNumber(this.cds.getXmiIdAsInt(fs));
            } else {
                this.isEmbeddedFromFsFeature = false;
                this.writeEmbeddedFs(fs);
            }
        }

        private void writeEmbeddedFs(TOP fs) throws IOException {
            boolean savedEmbedded = this.isEmbedded;
            try {
                this.isEmbedded = true;
                this.cds.encodeFS(fs);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.isEmbedded = savedEmbedded;
            }
        }

        private void writeFsOrRef(TOP fs, FeatureImpl fi) throws IOException {
            if (fs == null || !this.cds.isDynamicMultiRef || this.cds.multiRefFSs.contains(fs)) {
                this.jg.writeFieldName((SerializableString)this.getShortFeatureName(fi));
                this.jg.writeNumber(this.cds.getXmiIdAsInt(fs));
            } else {
                this.jch.writeNlJustBeforeNext();
                this.jg.writeFieldName((SerializableString)this.getShortFeatureName(fi));
                this.isEmbeddedFromFsFeature = true;
                this.writeEmbeddedFs(fs);
                this.isEmbeddedFromFsFeature = false;
            }
        }

        protected void writeArrays(TOP fs, int typeCode, int typeClass) throws IOException {
            this.maybeWriteTypeFeat(fs._getTypeImpl());
            this.jg.writeFieldName((SerializableString)COLLECTION_NAME);
            this.writeJsonArrayValues(fs, typeClass);
        }

        protected void writeEndOfIndividualFs() throws IOException {
            this.jg.writeEndObject();
        }

        private void writeJsonArrayValues(TOP array, int arrayType) throws IOException {
            if (array == null) {
                this.jg.writeNull();
                return;
            }
            this.cds.visited_not_yet_written.remove(array);
            CommonArrayFS ca = (CommonArrayFS)array;
            int array_size = ca.size();
            if (arrayType == 15) {
                ByteArray ba = (ByteArray)array;
                this.jg.writeBinary(ba._getTheArray());
            } else {
                this.jg.writeStartArray();
                switch (arrayType) {
                    case 14: {
                        boolean[] a = ((BooleanArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeBoolean(a[i]));
                        break;
                    }
                    case 15: {
                        ByteArray ba = (ByteArray)array;
                        this.jg.writeBinary(ba._getTheArray());
                        break;
                    }
                    case 16: {
                        short[] a = ((ShortArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeNumber(a[i]));
                        break;
                    }
                    case 4: {
                        int[] a = ((IntegerArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeNumber(a[i]));
                        break;
                    }
                    case 17: {
                        long[] a = ((LongArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeNumber(a[i]));
                        break;
                    }
                    case 5: {
                        float[] a = ((FloatArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeNumber(a[i]));
                        break;
                    }
                    case 18: {
                        double[] a = ((DoubleArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeNumber(a[i]));
                        break;
                    }
                    case 6: {
                        String[] a = ((StringArray)array)._getTheArray();
                        this.writeArrayElements(array_size, i -> this.jg.writeString(a[i]));
                        break;
                    }
                    case 7: {
                        this.writeFSArray(array, array_size);
                        break;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
                this.jg.writeEndArray();
            }
        }

        private void writeArrayElements(int size, IntConsumer_withIOException ic) throws IOException {
            for (int i = 0; i < size; ++i) {
                ic.accept(i);
            }
        }

        private void writeFSArray(TOP array, int array_size) throws NumberFormatException, IOException {
            FSArray fsArray = (FSArray)array;
            List ootsArrayElementsList = this.cds.sharedData == null ? null : this.cds.sharedData.getOutOfTypeSystemArrayElements(fsArray);
            int ootsIndex = 0;
            TOP[] fsItems = fsArray._getTheArray();
            for (int j = 0; j < array_size; ++j) {
                String typeName;
                TOP fsItem = fsItems[j];
                if (fsItem == null) {
                    boolean found = false;
                    if (ootsArrayElementsList != null) {
                        while (ootsIndex < ootsArrayElementsList.size()) {
                            XmiSerializationSharedData.XmiArrayElement arel = (XmiSerializationSharedData.XmiArrayElement)ootsArrayElementsList.get(ootsIndex++);
                            if (arel.index != j) continue;
                            this.jg.writeNumber(Integer.parseInt(arel.xmiId));
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    this.jg.writeNumber(0);
                    continue;
                }
                if (this.cds.isFiltering && this.cds.filterTypeSystem_inner.getType(typeName = fsItem._getTypeImpl().getName()) == null) {
                    fsItem = null;
                }
                this.writeFsOrRef(fsItem);
            }
        }

        private void writeJsonListValues(TOP curNode) throws IOException {
            if (curNode == null) {
                Misc.internalError();
            }
            PositiveIntSet_impl visited = new PositiveIntSet_impl();
            this.jg.writeStartArray();
            CommonList nextNode = null;
            while (curNode != null) {
                this.cds.visited_not_yet_written.remove(curNode);
                if (curNode instanceof EmptyList || !visited.add(curNode._id())) break;
                if (curNode instanceof NonEmptyStringList) {
                    l = (NonEmptyStringList)curNode;
                    this.jg.writeString(l.getHead());
                    nextNode = l.getCommonTail();
                } else if (curNode instanceof NonEmptyFloatList) {
                    l = (NonEmptyFloatList)curNode;
                    this.jg.writeNumber(l.getHead());
                    nextNode = l.getCommonTail();
                } else if (curNode instanceof NonEmptyFSList) {
                    l = (NonEmptyFSList)curNode;
                    this.writeFsOrRef((TOP)l);
                    nextNode = l.getCommonTail();
                } else {
                    l = (NonEmptyIntegerList)curNode;
                    this.jg.writeNumber(l.getHead());
                    nextNode = l.getCommonTail();
                }
                curNode = (TOP)nextNode;
            }
            this.jg.writeEndArray();
        }

        private SerializedString featureTypeLabel(int fsClass) {
            switch (fsClass) {
                case 7: 
                case 8: 
                case 104: {
                    return FEATURE_REFS_NAME;
                }
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 101: 
                case 102: 
                case 103: {
                    return FEATURE_ARRAY_NAME;
                }
                case 15: {
                    return FEATURE_BYTE_ARRAY_NAME;
                }
            }
            return null;
        }

        protected XmlElementName uimaTypeName2XmiElementName(String uimaTypeName) {
            int lastDotIndex = uimaTypeName.lastIndexOf(46);
            String shortName = lastDotIndex == -1 ? uimaTypeName : uimaTypeName.substring(lastDotIndex + 1);
            shortName = this.cds.getUniqueString(shortName);
            return new XmlElementName(uimaTypeName, shortName, shortName);
        }

        protected void addNameSpace(XmlElementName xmlElementName) {
            if (xmlElementName.qName.equals(xmlElementName.localName)) {
                String uimaTypeName = xmlElementName.nsUri;
                String shortName = xmlElementName.localName;
                int lastDotIndex = uimaTypeName.lastIndexOf(46);
                String prefix = this.cds.getNameSpacePrefix(uimaTypeName, uimaTypeName, lastDotIndex);
                xmlElementName.qName = this.cds.getUniqueString(prefix + ":" + shortName);
            }
        }

        private boolean isDynamicOrStaticMultiRef(FeatureImpl fi, TOP fs) {
            return !this.cds.isDynamicMultiRef ? this.cds.isStaticMultiRef(fi) : this.cds.multiRefFSs.contains(fs);
        }

        private boolean isDynamicOrStaticMultiRef(FeatureImpl fi, TOP fs, boolean isListAsFSs) {
            return !this.cds.isDynamicMultiRef ? isListAsFSs || this.cds.isStaticMultiRef(fi) : this.cds.multiRefFSs.contains(fs);
        }
    }

    public static enum JsonContextFormat {
        omitContext,
        omitSubtypes,
        omitExpandedTypeNames;

    }

    private static class MapType2Subtypes
    extends RedBlackTree<IntVector> {
        private MapType2Subtypes() {
        }

        boolean addSubtype(int type, int subtype) {
            IntVector iv = (IntVector)this.get(type);
            if (null == iv) {
                iv = new IntVector();
                iv.add(subtype);
                this.put(type, iv);
                return true;
            }
            if (iv.contains(subtype)) {
                return false;
            }
            iv.add(subtype);
            return true;
        }
    }
}

