/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cas;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class RegExAnnotator
extends CasAnnotator_ImplBase {
    public static final String MESSAGE_DIGEST = "org.apache.uima.examples.cas.RegExAnnotator_Messages";
    private Pattern[][] mPatterns;
    private ArrayList<String> mTypeNames;
    private String[] mContainingAnnotationTypeNames;
    private Type[] mCASTypes;
    private Type[] mContainingAnnotationTypes;
    private Boolean mAnnotateEntireContainingAnnotation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            InputStream in;
            String[] patternStrings = (String[])this.getContext().getConfigParameterValue("Patterns");
            String[] typeNames = (String[])this.getContext().getConfigParameterValue("TypeNames");
            this.mContainingAnnotationTypeNames = (String[])this.getContext().getConfigParameterValue("ContainingAnnotationTypes");
            this.mAnnotateEntireContainingAnnotation = this.mContainingAnnotationTypeNames != null && this.mContainingAnnotationTypeNames.length > 0 ? (Boolean)this.getContext().getConfigParameterValue("AnnotateEntireContainingAnnotation") : Boolean.FALSE;
            this.mTypeNames = new ArrayList();
            ArrayList<String[]> patternArray = new ArrayList<String[]>();
            if (patternStrings != null) {
                if (typeNames == null || typeNames.length != patternStrings.length) {
                    throw new ResourceInitializationException(MESSAGE_DIGEST, "type_pattern_array_length_mismatch", new Object[0]);
                }
                this.mTypeNames.addAll(Arrays.asList(typeNames));
                for (int i = 0; i < patternStrings.length; ++i) {
                    patternArray.add(new String[]{patternStrings[i]});
                }
            }
            if ((in = this.getContext().getResourceAsStream("PatternFile")) != null) {
                try {
                    String[] pats;
                    ArrayList<String> patternsForCurrentType = new ArrayList<String>();
                    boolean foundFirstType = false;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && line.length() > 0 && !Character.isWhitespace(line.charAt(0))) {
                            if (line.startsWith("%")) {
                                if (foundFirstType) {
                                    pats = new String[patternsForCurrentType.size()];
                                    patternsForCurrentType.toArray(pats);
                                    patternArray.add(pats);
                                    patternsForCurrentType.clear();
                                }
                                this.mTypeNames.add(line.substring(1));
                                foundFirstType = true;
                            } else {
                                patternsForCurrentType.add(line);
                            }
                        }
                        line = reader.readLine();
                    }
                    pats = new String[patternsForCurrentType.size()];
                    patternsForCurrentType.toArray(pats);
                    patternArray.add(pats);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (patternArray.isEmpty()) {
                throw new ResourceInitializationException("annotator_one_param_required", new Object[]{"Patterns, Pattern File"});
            }
            this.mPatterns = new Pattern[patternArray.size()][];
            for (int i = 0; i < patternArray.size(); ++i) {
                String[] pats = (String[])patternArray.get(i);
                this.mPatterns[i] = new Pattern[pats.length];
                for (int j = 0; j < this.mPatterns[i].length; ++j) {
                    try {
                        this.mPatterns[i][j] = Pattern.compile(pats[j]);
                        if (!this.mPatterns[i][j].matcher("").matches()) continue;
                        throw new ResourceInitializationException(MESSAGE_DIGEST, "regex_matches_empty_string", new Object[]{pats[j]});
                    }
                    catch (PatternSyntaxException e) {
                        throw new ResourceInitializationException(MESSAGE_DIGEST, "regex_syntax_error", new Object[]{pats[j]}, (Throwable)e);
                    }
                }
            }
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        int i;
        this.mCASTypes = new Type[this.mTypeNames.size()];
        for (i = 0; i < this.mTypeNames.size(); ++i) {
            String curTypeName = this.mTypeNames.get(i);
            this.mCASTypes[i] = aTypeSystem.getType(curTypeName);
            if (this.mCASTypes[i] != null) continue;
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{((Object)((Object)this)).getClass().getName(), curTypeName});
        }
        if (this.mContainingAnnotationTypeNames == null) {
            this.mContainingAnnotationTypes = null;
        } else {
            this.mContainingAnnotationTypes = new Type[this.mContainingAnnotationTypeNames.length];
            for (i = 0; i < this.mContainingAnnotationTypes.length; ++i) {
                this.mContainingAnnotationTypes[i] = aTypeSystem.getType(this.mContainingAnnotationTypeNames[i]);
                if (this.mContainingAnnotationTypes[i] != null) continue;
                throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{((Object)((Object)this)).getClass().getName(), this.mContainingAnnotationTypeNames[i]});
            }
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        try {
            String docText = aCAS.getDocumentText();
            int[] rangesToAnnotate = this.getRangesToAnnotate(aCAS);
            for (int i = 0; i < rangesToAnnotate.length; i += 2) {
                int startPos = rangesToAnnotate[i];
                int endPos = rangesToAnnotate[i + 1];
                String subText = docText.substring(startPos, endPos);
                for (int j = 0; j < this.mCASTypes.length; ++j) {
                    if (!this.getResultSpecification().containsType(this.mCASTypes[j].getName(), aCAS.getDocumentLanguage()) && !this.getResultSpecification().containsType(this.mCASTypes[j].getName())) continue;
                    for (int k = 0; k < this.mPatterns[j].length; ++k) {
                        int pos = 0;
                        Matcher matcher = this.mPatterns[j][k].matcher(subText);
                        while (pos < subText.length() && matcher.find(pos)) {
                            int annotEnd;
                            int annotStart;
                            this.getContext().getLogger().log(Level.FINER, "RegEx match found: [" + matcher.group() + "]");
                            if (this.mAnnotateEntireContainingAnnotation.booleanValue()) {
                                annotStart = startPos;
                                annotEnd = endPos;
                            } else {
                                annotStart = startPos + matcher.start();
                                annotEnd = startPos + matcher.end();
                            }
                            AnnotationFS fs = aCAS.createAnnotation(this.mCASTypes[j], annotStart, annotEnd);
                            aCAS.getIndexRepository().addFS((FeatureStructure)fs);
                            pos = annotEnd - startPos;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected int[] getRangesToAnnotate(CAS aCAS) {
        if (this.mContainingAnnotationTypes == null || this.mContainingAnnotationTypes.length == 0) {
            return new int[]{0, aCAS.getDocumentText().length()};
        }
        FSIterator iterator = aCAS.getAnnotationIndex().iterator();
        FSTypeConstraint constraint = aCAS.getConstraintFactory().createTypeConstraint();
        for (int i = 0; i < this.mContainingAnnotationTypes.length; ++i) {
            constraint.add(this.mContainingAnnotationTypes[i]);
        }
        iterator = aCAS.createFilteredIterator(iterator, (FSMatchConstraint)constraint);
        ArrayList<AnnotationFS> annotationList = new ArrayList<AnnotationFS>();
        while (iterator.isValid()) {
            annotationList.add((AnnotationFS)iterator.get());
            iterator.moveToNext();
        }
        int numRanges = annotationList.size();
        int[] result = new int[numRanges * 2];
        for (int j = 0; j < numRanges; ++j) {
            AnnotationFS curFS = (AnnotationFS)annotationList.get(j);
            result[j * 2] = curFS.getBegin();
            result[j * 2 + 1] = curFS.getEnd();
        }
        return result;
    }
}

