/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class GetListAction
extends AbstractRutaAction {
    private static final String TYPES = "Types";
    private static final String TYPES_AT_END = "Types:End";
    private static final String TYPES_AT_BEGIN = "Types:Begin";
    private String var;
    private IStringExpression opExpr;

    public GetListAction(String var, IStringExpression op) {
        this.var = var;
        this.opExpr = op;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        String op = this.opExpr.getStringValue(context, stream);
        ArrayList<Type> list = new ArrayList<Type>();
        int indexOf = element.getContainer().getRuleElements().indexOf(element);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(indexOf + 1);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexes, element.getContainer());
        block0: for (AnnotationFS matched : matchedAnnotations) {
            HashSet aset;
            if (TYPES_AT_BEGIN.equals(op)) {
                RutaBasic beginAnchor = stream.getBeginAnchor(matched.getBegin());
                Collection<?>[] beginMap = beginAnchor.getBeginMap();
                aset = new HashSet();
                for (Collection<?> collection : beginMap) {
                    if (collection == null) continue;
                    aset.addAll(collection);
                }
                for (AnnotationFS annotationFS : aset) {
                    list.add(annotationFS.getType());
                }
                continue;
            }
            if (TYPES_AT_END.equals(op)) {
                RutaBasic endAnchor = stream.getEndAnchor(matched.getEnd());
                Collection<?>[] endMap = endAnchor.getEndMap();
                aset = new HashSet();
                for (Collection<?> collection : endMap) {
                    if (collection == null) continue;
                    aset.addAll(collection);
                }
                for (AnnotationFS annotationFS : aset) {
                    list.add(annotationFS.getType());
                }
                continue;
            }
            if (!TYPES.equals(op)) continue;
            Type annotationType = stream.getCas().getAnnotationType();
            List<AnnotationFS> inWindow = stream.getAnnotationsInWindow(matched, annotationType);
            for (AnnotationFS each : inWindow) {
                if (each.getBegin() == matched.getBegin() && each.getEnd() == matched.getEnd()) {
                    list.add(each.getType());
                }
                if (each.getBegin() <= matched.getBegin() && each.getEnd() >= matched.getEnd()) continue;
                continue block0;
            }
        }
        parent.getEnvironment().setVariableValue(this.var, list);
    }

    public String getVar() {
        return this.var;
    }

    public IStringExpression getOpExpr() {
        return this.opExpr;
    }
}

