/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.ee.ManagedRuntime;

public class WLSManagedRuntime
extends AbstractManagedRuntime
implements ManagedRuntime {
    private final Method _txHelperMeth;
    private final Method _txManagerMeth;

    public WLSManagedRuntime() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> txHelper = Class.forName("weblogic.transaction.TransactionHelper");
        this._txHelperMeth = txHelper.getMethod("getTransactionHelper", null);
        this._txManagerMeth = txHelper.getMethod("getTransactionManager", null);
    }

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        Object o = this._txHelperMeth.invoke(null, null);
        return (TransactionManager)this._txManagerMeth.invoke(o, null);
    }

    @Override
    public void setRollbackOnly(Throwable cause) throws Exception {
        Transaction transaction = this.getTransactionManager().getTransaction();
        try {
            transaction.getClass().getMethod("setRollbackOnly", Throwable.class).invoke((Object)transaction, cause);
        }
        catch (Throwable e) {
            transaction.setRollbackOnly();
        }
    }

    @Override
    public Throwable getRollbackCause() throws Exception {
        Transaction transaction = this.getTransactionManager().getTransaction();
        try {
            return (Throwable)transaction.getClass().getMethod("getRollbackReason", new Class[0]).invoke((Object)transaction, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

