/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.Locale;
import javax.security.auth.login.LoginException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Base64;

public class BasicAuthHttpListenerWrapper
implements HttpListener {
    private final HttpListener httpListener;
    private final String realmName;

    public BasicAuthHttpListenerWrapper(HttpListener httpListener, String realmName) {
        this.httpListener = httpListener;
        this.realmName = realmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        String decoded;
        String[] parts;
        Object token = null;
        String auth = request.getHeader("Authorization");
        if (auth != null && auth.length() > 0 && auth.toUpperCase(Locale.ENGLISH).startsWith("BASIC ") && (parts = (decoded = new String(Base64.decodeBase64((byte[])(auth = auth.substring(6)).getBytes()))).split(":")).length == 2) {
            String username = parts[0];
            String password = parts[1];
            try {
                SecurityService securityService = this.getSecurityService();
                token = securityService.login(this.realmName, username, password);
                if (token != null) {
                    securityService.associate(token);
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        try {
            if (token != null || HttpRequest.Method.GET.name().equals(request.getMethod())) {
                this.httpListener.onMessage(request, response);
            }
        }
        finally {
            SecurityService securityService;
            Object disassociate;
            if (token != null && (disassociate = (securityService = this.getSecurityService()).disassociate()) != null) {
                securityService.logout(disassociate);
            }
        }
    }

    private SecurityService getSecurityService() {
        return (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
    }

    public HttpListener getHttpListener() {
        return this.httpListener;
    }
}

