/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.util.Collection;

public class ComponentUtils {
    public static final String V_ID_PREFIX = "__v_";
    public static final String RD_ID_PREFIX = "__rd_";
    public static final int UNIQUE_COMPONENT_V_IDS_SIZE = 50;
    public static final int UNIQUE_COMPONENT_RD_IDS_SIZE = 50;
    public static final String[] UNIQUE_COMPONENT_V_IDS;
    public static final String[] UNIQUE_COMPONENT_RD_IDS;

    private ComponentUtils() {
    }

    public static UIComponent findClosestNamingContainer(UIComponent component, boolean returnRootIfNotFound) {
        NamingContainer result = ComponentUtils.findClosest(NamingContainer.class, component);
        if (result != null) {
            return (UIComponent)((Object)result);
        }
        if (returnRootIfNotFound) {
            return ComponentUtils.findRootComponent(component);
        }
        return null;
    }

    public static <T> T findClosest(Class<T> type, UIComponent base) {
        for (UIComponent parent = base.getParent(); parent != null; parent = parent.getParent()) {
            if (!type.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    public static UIComponent findRootComponent(UIComponent component) {
        UIComponent parent;
        while ((parent = component.getParent()) != null) {
            component = parent;
        }
        return component;
    }

    public static UIComponent findComponent(UIComponent findBase, String id, char separatorChar) {
        if (!(findBase instanceof NamingContainer) && id.equals(findBase.getId())) {
            return findBase;
        }
        int facetCount = findBase.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : findBase.getFacets().values()) {
                if (!(facet instanceof NamingContainer)) {
                    UIComponent find = ComponentUtils.findComponent(facet, id, separatorChar);
                    if (find == null) continue;
                    return find;
                }
                if (!id.equals(facet.getId())) continue;
                return facet;
            }
        }
        int childCount = findBase.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = findBase.getChildren().get(i);
            if (!(child instanceof NamingContainer)) {
                UIComponent find = ComponentUtils.findComponent(child, id, separatorChar);
                if (find == null) continue;
                return find;
            }
            if (!id.equals(child.getId())) continue;
            return child;
        }
        if (findBase instanceof NamingContainer && id.equals(findBase.getId())) {
            return findBase;
        }
        return null;
    }

    public static UIComponent findComponentChildOrFacetFrom(UIComponent parent, String id, String innerExpr) {
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                UIComponent find;
                if (id.equals(facet.getId())) {
                    if (innerExpr == null) {
                        return facet;
                    }
                    if (!(facet instanceof NamingContainer) || (find = facet.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (facet instanceof NamingContainer || (find = ComponentUtils.findComponentChildOrFacetFrom(facet, id, innerExpr)) == null) continue;
                return find;
            }
        }
        if (parent.getChildCount() > 0) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent find;
                UIComponent child = parent.getChildren().get(i);
                if (id.equals(child.getId())) {
                    if (innerExpr == null) {
                        return child;
                    }
                    if (!(child instanceof NamingContainer) || (find = child.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (child instanceof NamingContainer || (find = ComponentUtils.findComponentChildOrFacetFrom(child, id, innerExpr)) == null) continue;
                return find;
            }
        }
        return null;
    }

    public static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                Collection<FacesMessage> facesMessages;
                input.setValid(false);
                String validatorMessage = input.getValidatorMessage();
                if (validatorMessage != null) {
                    context.addMessage(input.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage));
                    continue;
                }
                FacesMessage facesMessage = e.getFacesMessage();
                if (facesMessage != null) {
                    context.addMessage(input.getClientId(context), facesMessage);
                }
                if ((facesMessages = e.getFacesMessages()) == null) continue;
                for (FacesMessage message : facesMessages) {
                    context.addMessage(input.getClientId(context), message);
                }
            }
        }
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuilder buf = new StringBuilder();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        ComponentUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        Object location = component.getAttributes().get("jakarta.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            buf.append(" Location: ").append(location);
        }
        buf.append('}');
        return buf.toString();
    }

    public static boolean isRendered(FacesContext facesContext, UIComponent uiComponent) {
        try {
            uiComponent.pushComponentToEL(facesContext, uiComponent);
            boolean bl = uiComponent.isRendered();
            return bl;
        }
        finally {
            uiComponent.popComponentFromEL(facesContext);
        }
    }

    public static void getPathToComponent(UIComponent component, StringBuilder buf) {
        if (component == null) {
            return;
        }
        StringBuilder intBuf = new StringBuilder();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append(']');
        buf.insert(0, intBuf.toString());
        ComponentUtils.getPathToComponent(component.getParent(), buf);
    }

    static {
        int i;
        String[] uniqueV = new String[50];
        String[] uniqueRD = new String[50];
        StringBuilder bld = new StringBuilder(20);
        for (i = 0; i < 50; ++i) {
            uniqueV[i] = bld.append("j_id").append(V_ID_PREFIX).append(i).toString();
            bld.setLength(0);
        }
        for (i = 0; i < 50; ++i) {
            uniqueRD[i] = bld.append("j_id").append(RD_ID_PREFIX).append(i).toString();
            bld.setLength(0);
        }
        UNIQUE_COMPONENT_RD_IDS = uniqueRD;
        UNIQUE_COMPONENT_V_IDS = uniqueV;
    }
}

