/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class InvocationBuilderImpl
implements Invocation.Builder {
    private static final String PROPERTY_KEY = "jaxrs.filter.properties";
    private WebClient webClient;
    private SyncInvoker sync;
    private Configuration config;

    public InvocationBuilderImpl(WebClient webClient, Configuration config) {
        this.webClient = webClient;
        this.sync = webClient.sync();
        this.config = config;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public Response delete() {
        return this.sync.delete();
    }

    public <T> T delete(Class<T> cls) {
        return (T)this.sync.delete(cls);
    }

    public <T> T delete(GenericType<T> type) {
        return (T)this.sync.delete(type);
    }

    public Response get() {
        return this.sync.get();
    }

    public <T> T get(Class<T> cls) {
        return (T)this.sync.get(cls);
    }

    public <T> T get(GenericType<T> type) {
        return (T)this.sync.get(type);
    }

    public Response head() {
        return this.sync.head();
    }

    public Response method(String method) {
        return this.sync.method(method);
    }

    public <T> T method(String method, Class<T> cls) {
        return (T)this.sync.method(method, cls);
    }

    public <T> T method(String method, GenericType<T> type) {
        return (T)this.sync.method(method, type);
    }

    public Response method(String method, Entity<?> entity) {
        return this.sync.method(method, entity);
    }

    public <T> T method(String method, Entity<?> entity, Class<T> cls) {
        return (T)this.sync.method(method, entity, cls);
    }

    public <T> T method(String method, Entity<?> entity, GenericType<T> type) {
        return (T)this.sync.method(method, entity, type);
    }

    public Response options() {
        return this.sync.options();
    }

    public <T> T options(Class<T> cls) {
        return (T)this.sync.options(cls);
    }

    public <T> T options(GenericType<T> type) {
        return (T)this.sync.options(type);
    }

    public Response post(Entity<?> entity) {
        return this.sync.post(entity);
    }

    public <T> T post(Entity<?> entity, Class<T> cls) {
        return (T)this.sync.post(entity, cls);
    }

    public <T> T post(Entity<?> entity, GenericType<T> type) {
        return (T)this.sync.post(entity, type);
    }

    public Response put(Entity<?> entity) {
        return this.sync.put(entity);
    }

    public <T> T put(Entity<?> entity, Class<T> cls) {
        return (T)this.sync.put(entity, cls);
    }

    public <T> T put(Entity<?> entity, GenericType<T> type) {
        return (T)this.sync.put(entity, type);
    }

    public Response trace() {
        return this.sync.trace();
    }

    public <T> T trace(Class<T> cls) {
        return (T)this.sync.trace(cls);
    }

    public <T> T trace(GenericType<T> type) {
        return (T)this.sync.trace(type);
    }

    public Invocation.Builder accept(String ... types) {
        this.webClient.accept(types);
        return this;
    }

    public Invocation.Builder accept(MediaType ... types) {
        this.webClient.accept(types);
        return this;
    }

    public Invocation.Builder acceptEncoding(String ... enc) {
        this.webClient.acceptEncoding(enc);
        return this;
    }

    public Invocation.Builder acceptLanguage(Locale ... lang) {
        for (Locale l : lang) {
            this.webClient.acceptLanguage(HttpUtils.toHttpLanguage((Locale)l));
        }
        return this;
    }

    public Invocation.Builder acceptLanguage(String ... lang) {
        this.webClient.acceptLanguage(lang);
        return this;
    }

    public Invocation.Builder cacheControl(CacheControl control) {
        this.webClient.header("Cache-Control", control.toString());
        return this;
    }

    public Invocation.Builder cookie(Cookie cookie) {
        this.webClient.cookie(cookie);
        return this;
    }

    public Invocation.Builder cookie(String name, String value) {
        this.webClient.header("Cookie", name + "=" + value);
        return this;
    }

    public Invocation.Builder header(String name, Object value) {
        RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
        this.doSetHeader(rd, name, value);
        return this;
    }

    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.webClient.removeAllHeaders();
        if (headers != null) {
            RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
            for (Map.Entry entry : headers.entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    this.doSetHeader(rd, (String)entry.getKey(), value);
                }
            }
        }
        return this;
    }

    private void doSetHeader(RuntimeDelegate rd, String name, Object value) {
        RuntimeDelegate.HeaderDelegate hd = HttpUtils.getHeaderDelegate((RuntimeDelegate)rd, (Object)value);
        if (hd != null) {
            value = hd.toString(value);
        }
        if (value == null) {
            this.webClient.replaceHeader(name, value);
        } else {
            this.webClient.header(name, value);
        }
    }

    public Invocation.Builder property(String name, Object value) {
        Map<String, Object> contextProps = WebClient.getConfig(this.webClient).getRequestContext();
        HashMap<String, Object> filterProps = CastUtils.cast((Map)((Map)contextProps.get(PROPERTY_KEY)));
        if (filterProps == null) {
            filterProps = new HashMap<String, Object>();
            contextProps.put(PROPERTY_KEY, filterProps);
        }
        if (value == null) {
            filterProps.remove(name);
        } else {
            filterProps.put(name, value);
        }
        return this;
    }

    public AsyncInvoker async() {
        return this.webClient.async();
    }

    public Invocation build(String method) {
        return new InvocationImpl(method);
    }

    public Invocation build(String method, Entity<?> entity) {
        return new InvocationImpl(method, entity);
    }

    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    public Invocation buildGet() {
        return this.build("GET");
    }

    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    public CompletionStageRxInvoker rx() {
        return this.webClient.rx(this.getConfiguredExecutorService());
    }

    public <T extends RxInvoker> T rx(Class<T> rxCls) {
        return this.webClient.rx(rxCls, this.getConfiguredExecutorService());
    }

    private ExecutorService getConfiguredExecutorService() {
        return (ExecutorService)this.config.getProperty("executorService");
    }

    private class InvocationImpl
    implements Invocation {
        private Invocation.Builder invBuilder;
        private String httpMethod;
        private Entity<?> entity;

        InvocationImpl(String httpMethod) {
            this(httpMethod, null);
        }

        InvocationImpl(String httpMethod, Entity<?> entity) {
            this.invBuilder = InvocationBuilderImpl.this;
            this.httpMethod = httpMethod;
            this.entity = entity;
        }

        public Response invoke() {
            return this.invBuilder.method(this.httpMethod, this.entity);
        }

        public <T> T invoke(Class<T> cls) {
            return (T)this.invBuilder.method(this.httpMethod, this.entity, cls);
        }

        public <T> T invoke(GenericType<T> type) {
            return (T)this.invBuilder.method(this.httpMethod, this.entity, type);
        }

        public Invocation property(String name, Object value) {
            this.invBuilder.property(name, value);
            return this;
        }

        public Future<Response> submit() {
            return this.invBuilder.async().method(this.httpMethod, this.entity);
        }

        public <T> Future<T> submit(Class<T> cls) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, cls);
        }

        public <T> Future<T> submit(GenericType<T> type) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, type);
        }

        public <T> Future<T> submit(InvocationCallback<T> callback) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, callback);
        }
    }
}

