/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.PersistenceContextSynchronization;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.PersistenceRef;
import org.apache.openejb.jee.Property;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="persistence-context-refType", propOrder={"descriptions", "persistenceContextRefName", "persistenceUnitName", "persistenceContextType", "persistenceContextSynchronization", "persistenceProperty", "mappedName", "injectionTarget", "lookupName"})
public class PersistenceContextRef
implements JndiReference,
PersistenceRef {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="persistence-context-ref-name", required=true)
    protected String persistenceContextRefName;
    @XmlElement(name="persistence-unit-name")
    protected String persistenceUnitName;
    @XmlElement(name="persistence-context-type")
    protected PersistenceContextType persistenceContextType;
    @XmlElement(name="persistence-context-synchronization")
    protected PersistenceContextSynchronization persistenceContextSynchronization;
    @XmlElement(name="persistence-property", required=true)
    protected List<Property> persistenceProperty;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public PersistenceContextRef() {
    }

    public PersistenceContextRef(String persistenceContextRefName, String persistenceUnitName) {
        this.persistenceContextRefName = persistenceContextRefName;
        this.persistenceUnitName = persistenceUnitName;
    }

    public PersistenceContextRef(String persistenceContextRefName, String persistenceUnitName, PersistenceContextType persistenceContextType, List<Property> persistenceProperty) {
        this.persistenceContextRefName = persistenceContextRefName;
        this.persistenceUnitName = persistenceUnitName;
        this.persistenceContextType = persistenceContextType;
        this.persistenceProperty = persistenceProperty;
    }

    public PersistenceContextRef name(String persistenceContextRefName) {
        this.persistenceContextRefName = persistenceContextRefName;
        return this;
    }

    public PersistenceContextRef unit(String persistenceUnit) {
        this.persistenceUnitName = persistenceUnit;
        return this;
    }

    public PersistenceContextRef type(PersistenceContextType persistenceContextType) {
        this.persistenceContextType = persistenceContextType;
        return this;
    }

    public PersistenceContextRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public PersistenceContextRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public PersistenceContextRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.persistenceContextRefName == null) {
            this.persistenceContextRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public PersistenceContextRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    public PersistenceContextRef property(String name, String value) {
        this.getPersistenceProperty().add(new Property(name, value));
        return this;
    }

    @Override
    public String getName() {
        return this.getPersistenceContextRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public String getType() {
        return this.getPersistenceContextType().name();
    }

    @Override
    public void setName(String name) {
        this.setPersistenceContextRefName(name);
    }

    @Override
    public void setType(String type) {
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getPersistenceContextRefName() {
        return this.persistenceContextRefName;
    }

    public void setPersistenceContextRefName(String value) {
        this.persistenceContextRefName = value;
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    @Override
    public void setPersistenceUnitName(String value) {
        this.persistenceUnitName = value;
    }

    public PersistenceContextType getPersistenceContextType() {
        return this.persistenceContextType;
    }

    public void setPersistenceContextType(PersistenceContextType value) {
        this.persistenceContextType = value;
    }

    public PersistenceContextSynchronization getPersistenceContextSynchronization() {
        return this.persistenceContextSynchronization;
    }

    public void setPersistenceContextSynchronization(PersistenceContextSynchronization persistenceContextSynchronization) {
        this.persistenceContextSynchronization = persistenceContextSynchronization;
    }

    public List<Property> getPersistenceProperty() {
        if (this.persistenceProperty == null) {
            this.persistenceProperty = new ArrayList<Property>();
        }
        return this.persistenceProperty;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void setPersistenceProperty(List<Property> persistenceProperty) {
        this.persistenceProperty = persistenceProperty;
    }

    public String toString() {
        return "PersistenceContextRef{name='" + this.persistenceContextRefName + "', unit='" + this.persistenceUnitName + "', context=" + this.persistenceContextType + ", mappedName='" + this.mappedName + "', lookupName='" + this.lookupName + "'}";
    }
}

