/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.smallrye.metrics.MPPrometheusConfig;
import io.smallrye.metrics.base.LegacyBaseMetrics;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.micrometer.MicrometerBackends;
import io.smallrye.metrics.micrometer.RequiresClass;
import io.smallrye.metrics.setup.ApplicationNameResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class SharedMetricRegistries {
    private static final String CLASS_NAME = SharedMetricRegistries.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    protected static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    protected static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    private static final String FQ_PROMETHEUS_CONFIG_PATH = "io.micrometer.prometheus.PrometheusConfig";
    private static final String FQ_PROMETHEUS_METRIC_REGISTRY_PATH = "io.micrometer.prometheus.PrometheusMeterRegistry";
    private static final Map<String, MetricRegistry> registries = new ConcurrentHashMap<String, MetricRegistry>();
    private static boolean isBaseMetricsRegistered = false;
    private static MeterRegistry meterRegistry;
    private static ApplicationNameResolver appNameResolver;

    public static void setAppNameResolver(ApplicationNameResolver anr) {
        appNameResolver = anr;
    }

    public static ApplicationNameResolver getAppNameResolver() {
        return appNameResolver;
    }

    public static Set<String> getRegistryScopeNames() {
        return new HashSet<String>(registries.keySet());
    }

    public static MetricRegistry getOrCreate(String scope) {
        ApplicationNameResolver anr = appNameResolver != null ? appNameResolver : null;
        return SharedMetricRegistries.getOrCreate(scope, anr);
    }

    public static MetricRegistry getOrCreate(String scope, ApplicationNameResolver anr) {
        String METHOD_NAME = "getOrCreate";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "getOrCreate", "Requested MetricRegistry of scope {0}", scope);
        }
        MetricRegistry metricRegistry = registries.computeIfAbsent(scope, t -> new LegacyMetricRegistryAdapter(scope, meterRegistry, anr));
        if (!isBaseMetricsRegistered && scope.equals("base")) {
            new LegacyBaseMetrics().register(metricRegistry);
            isBaseMetricsRegistered = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "getOrCreate", "Base metrics registered");
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "getOrCreate", "Returning MetricRegistry of scope \"{0}\"", scope);
        }
        return metricRegistry;
    }

    private static MeterRegistry resolveMeterRegistry() {
        SimpleMeterRegistry meterRegistry;
        String METHOD_NAME = "resolveMeterRegistry";
        if (!Boolean.parseBoolean(ConfigProvider.getConfig().getOptionalValue("mp.metrics.prometheus.enabled", String.class).orElse("true"))) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMeterRegistry", "The MP Config value for mp.metrics.prometheus.enabled is false");
            }
            meterRegistry = new SimpleMeterRegistry();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMeterRegistry", "Simple MeterRegistry created");
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMeterRegistry", "The MP Config value for mp.metrics.prometheus.enabled is true");
            }
            try {
                Class<?> prometheusConfigClass = Class.forName(FQ_PROMETHEUS_CONFIG_PATH);
                Class<?> prometheusMetricRegistryClass = Class.forName(FQ_PROMETHEUS_METRIC_REGISTRY_PATH);
                Constructor<?> constructor = prometheusMetricRegistryClass.getConstructor(prometheusConfigClass);
                Object prometheusMeterRegistryInstance = constructor.newInstance(new MPPrometheusConfig());
                meterRegistry = (MeterRegistry)prometheusMeterRegistryInstance;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMeterRegistry", "Prometheus MeterRegistry created");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "resolveMeterRegistry", "Encountered exception while reflectively loading Micrometer Prometheus classes: ", e);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "resolveMeterRegistry", "Encountered exception while loading Prometheus MeterRegistry, defaulting to Simple MeterRegistry");
                }
                meterRegistry = new SimpleMeterRegistry();
            }
        }
        Metrics.addRegistry((MeterRegistry)meterRegistry);
        return meterRegistry;
    }

    public static void drop(String scope) {
        registries.remove(scope);
    }

    public static void dropAll() {
        registries.clear();
    }

    public static boolean doesScopeExist(String scope) {
        return registries.containsKey(scope);
    }

    static {
        HashSet setOfMeterRegistryClasses = new HashSet();
        for (Class<?> clazz : MicrometerBackends.classes()) {
            try {
                RequiresClass requiresClass = clazz.getAnnotation(RequiresClass.class);
                Class<?>[] requiredClass = requiresClass.value();
                setOfMeterRegistryClasses.add(clazz);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.logp(Level.FINE, CLASS_NAME, null, "Required classes for \"{0}\" not found on classpath", clazz.getName());
            }
        }
        for (Class clazz : setOfMeterRegistryClasses) {
            if (MicrometerBackends.class.isAssignableFrom(clazz)) {
                try {
                    MicrometerBackends mb = (MicrometerBackends)clazz.newInstance();
                    MeterRegistry backendMeterRegistry = mb.produce();
                    if (backendMeterRegistry != null) {
                        Metrics.globalRegistry.add(backendMeterRegistry);
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.logp(Level.FINE, CLASS_NAME, null, "MeterRegistry from {0} created and registered to the Micrometer global registry", clazz.getName());
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.logp(Level.FINE, CLASS_NAME, null, "MeterRegistry from {0} is available on classpath, but was not configured to be enabled", clazz.getName());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.logp(Level.SEVERE, CLASS_NAME, (String)null, "Encountered exception while reflectively loading MicrometerBackends \"{0}\": {1}", new Object[]{clazz.getName(), e});
                }
                continue;
            }
            LOGGER.logp(Level.SEVERE, CLASS_NAME, (String)null, "The class {0} is not compatible with {1} ", new String[]{clazz.getName(), MicrometerBackends.class.getName()});
        }
        meterRegistry = SharedMetricRegistries.resolveMeterRegistry();
    }
}

