/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.HashMap;
import java.util.Objects;
import org.apache.openjpa.meta.XMLMetaData;

public class XMLClassMetaData
implements XMLMetaData {
    private static final long serialVersionUID = 1L;
    private Class _type;
    private int _code = 8;
    private int _xmltype = 0;
    private String _name = null;
    private String _xmlname = null;
    private String _xmlnamespace = null;
    private boolean _isXMLRootElement = false;
    private HashMap _fieldMap = new HashMap();

    public XMLClassMetaData(Class type, String name) {
        this._type = type;
        this._name = name;
    }

    public XMLClassMetaData(Class type) {
        this._type = type;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setXmlname(String name) {
        this._xmlname = name;
    }

    @Override
    public String getXmlname() {
        return this._isXMLRootElement ? null : this._xmlname;
    }

    @Override
    public void setXmlnamespace(String name) {
        if (!Objects.equals("##default", name)) {
            this._xmlnamespace = name;
        }
    }

    @Override
    public String getXmlnamespace() {
        return this._xmlnamespace;
    }

    @Override
    public void setXmlRootElement(boolean isXMLRootElement) {
        this._isXMLRootElement = isXMLRootElement;
    }

    @Override
    public boolean isXmlRootElement() {
        return this._isXMLRootElement;
    }

    @Override
    public boolean isXmlElement() {
        return false;
    }

    @Override
    public boolean isXmlAttribute() {
        return false;
    }

    @Override
    public XMLMetaData getFieldMapping(String name) {
        return (XMLMetaData)this._fieldMap.get(name);
    }

    @Override
    public void setType(Class type) {
        this._type = type;
    }

    @Override
    public Class getType() {
        return this._type;
    }

    @Override
    public int getTypeCode() {
        return this._code;
    }

    @Override
    public void setXmltype(int type) {
        this._xmltype = type;
    }

    @Override
    public int getXmltype() {
        return this._xmltype;
    }

    @Override
    public void addField(String name, XMLMetaData field) {
        this._fieldMap.put(name, field);
    }
}

