/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.apache.openjpa.lib.util.SizedMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentMap;

public class ConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
SizedMap,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final double[] RANDOMS = new double[1000];
    private transient Entry[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;
    private int randomEntry = 0;
    private int maxSize = Integer.MAX_VALUE;
    private static final Object NULL_KEY;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private transient Set entrySet = null;
    private transient Set keySet = null;
    private transient Collection values = null;
    private static final long serialVersionUID = -6452706556724125778L;

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f);
    }

    public ConcurrentHashMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        return h - (h << 7);
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    public final int capacity() {
        return this.table.length;
    }

    public final float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        int n = this.maxSize = maxSize < 0 ? Integer.MAX_VALUE : maxSize;
        if (this.maxSize != Integer.MAX_VALUE) {
            this.removeOverflow(this.maxSize);
        }
    }

    @Override
    public boolean isFull() {
        return this.maxSize != Integer.MAX_VALUE && this.size() >= this.maxSize;
    }

    @Override
    public void overflowRemoved(Object key, Object value) {
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object key) {
        Entry e = this.getEntry(key);
        return e == null ? null : e.value;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    protected Entry getEntry(Object key) {
        Object k = ConcurrentHashMap.maskNull(key);
        int hash = ConcurrentHashMap.hash(k);
        Entry[] tab = this.table;
        Entry e = tab[hash & tab.length - 1];
        while (e != null) {
            if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object k = ConcurrentHashMap.maskNull(key);
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry e = this.table[i];
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    Object oldValue = e.value;
                    e.value = value;
                    return oldValue;
                }
                e = e.next;
            }
            if (this.maxSize != Integer.MAX_VALUE) {
                this.removeOverflow(this.maxSize - 1);
            }
            this.table[i] = this.createEntry(hash, k, value, this.table[i]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    private void removeOverflow(int maxSize) {
        Map.Entry entry;
        while (this.size > maxSize && (entry = this.removeRandom()) != null) {
            this.overflowRemoved(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object key, Object value) {
        Object k = ConcurrentHashMap.maskNull(key);
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry e = this.table[i];
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    return e.value;
                }
                e = e.next;
            }
            if (this.maxSize != Integer.MAX_VALUE) {
                this.removeOverflow(this.maxSize - 1);
            }
            this.table[i] = this.createEntry(hash, k, value, this.table[i]);
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return null;
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        int mask = newCapacity - 1;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry e = oldTable[i];
            while (e != null) {
                Entry clone = (Entry)e.clone();
                int j = clone.hash & mask;
                clone.next = newTable[j];
                newTable[j] = clone;
                e = e.next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    public final synchronized void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        Iterator iterator = t.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? e : e.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry removeEntryForKey(Object key) {
        Object k = ConcurrentHashMap.maskNull(key);
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry e = this.table[i];
            if (e == null) {
                return null;
            }
            if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                --this.size;
                this.table[i] = e.next;
                return e;
            }
            Entry prev = e;
            e = e.next;
            while (e != null) {
                if (e.hash == hash && ConcurrentHashMap.eq(k, e.key)) {
                    --this.size;
                    prev.next = e.next;
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry removeMapping(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object k = ConcurrentHashMap.maskNull(entry.getKey());
        int hash = ConcurrentHashMap.hash(k);
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int i = hash & this.table.length - 1;
            Entry e = this.table[i];
            if (e == null) {
                return null;
            }
            if (e.hash == hash && e.equals(entry)) {
                --this.size;
                this.table[i] = e.next;
                return e;
            }
            Entry prev = e;
            e = e.next;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    --this.size;
                    prev.next = e.next;
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.table = new Entry[this.table.length];
        this.size = 0;
    }

    private int randomEntryIndex() {
        if (this.randomEntry == RANDOMS.length) {
            this.randomEntry = 0;
        }
        return (int)(RANDOMS[this.randomEntry++] * (double)this.table.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry removeRandom() {
        if (this.size == 0) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = this;
        synchronized (concurrentHashMap) {
            int random = this.randomEntryIndex();
            int index = this.findEntry(random, random % 2 == 0, false);
            if (index == -1) {
                return null;
            }
            Entry rem = this.table[index];
            this.table[index] = rem.next;
            --this.size;
            return rem;
        }
    }

    private int findEntry(int start, boolean forward, boolean searchedOther) {
        if (forward) {
            for (int i = start; i < this.table.length; ++i) {
                if (this.table[i] == null) continue;
                return i;
            }
            return searchedOther || start == 0 ? -1 : this.findEntry(start - 1, false, true);
        }
        for (int i = start; i >= 0; --i) {
            if (this.table[i] == null) continue;
            return i;
        }
        return searchedOther || start == this.table.length - 1 ? -1 : this.findEntry(start + 1, true, true);
    }

    @Override
    public Iterator randomEntryIterator() {
        return new HashIterator(2, this.randomEntryIndex());
    }

    @Override
    public final boolean containsValue(Object value) {
        Entry[] tab;
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = tab = this.table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry e = entry = entryArray[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab;
        Entry[] entryArray = tab = this.table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry;
            Entry e = entry = entryArray[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public final Object clone() {
        return new ConcurrentHashMap(this);
    }

    protected Entry createEntry(int h, Object k, Object v, Entry n) {
        return new Entry(h, k, v, n);
    }

    public final Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public final Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public final Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        s.writeInt(this.maxSize);
        for (Object o : this.entrySet()) {
            Map.Entry e = (Map.Entry)o;
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int size = s.readInt();
        this.maxSize = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    static {
        Random random = new Random();
        for (int i = 0; i < RANDOMS.length; ++i) {
            ConcurrentHashMap.RANDOMS[i] = random.nextDouble();
        }
        NULL_KEY = new Object();
    }

    private final class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new HashIterator(2, ConcurrentHashMap.this.table.length - 1);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = ConcurrentHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new HashIterator(1, ConcurrentHashMap.this.table.length - 1);
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new HashIterator(0, ConcurrentHashMap.this.table.length - 1);
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private class HashIterator
    implements Iterator {
        final Entry[] table;
        final int type;
        int startIndex;
        int stopIndex;
        int index;
        Entry entry;
        Entry lastReturned;

        HashIterator(int type, int startIndex) {
            this.table = ConcurrentHashMap.this.table;
            this.stopIndex = 0;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
            this.startIndex = startIndex;
            this.index = startIndex;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index >= this.stopIndex) {
                if ((this.entry = this.table[this.index--]) == null) continue;
                return true;
            }
            if (this.stopIndex == 0) {
                this.index = this.table.length - 1;
                this.stopIndex = this.startIndex + 1;
                while (this.index >= this.stopIndex) {
                    if ((this.entry = this.table[this.index--]) == null) continue;
                    return true;
                }
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.entry;
            this.entry = e.next;
            return this.type == 0 ? e.key : (this.type == 1 ? e.value : e);
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap concurrentHashMap = ConcurrentHashMap.this;
            synchronized (concurrentHashMap) {
                Entry[] tab = ConcurrentHashMap.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --ConcurrentHashMap.this.size;
                        this.lastReturned = null;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new Error("Iterated off table when doing remove");
            }
        }
    }

    protected static class Entry
    implements Map.Entry {
        final Object key;
        Object value;
        final int hash;
        Entry next;

        protected Entry(int h, Object k, Object v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public Object getKey() {
            return ConcurrentHashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, null);
        }
    }
}

