/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.UnaryMathVal;
import org.apache.openjpa.kernel.exps.Val;

class Abs
extends UnaryMathVal {
    private static final long serialVersionUID = 1L;

    public Abs(Val val) {
        super(val);
    }

    @Override
    protected Class getType(Class c) {
        Class<?> wrap = Filters.wrap(c);
        if (wrap == Integer.class || wrap == Float.class || wrap == Double.class || wrap == Long.class || wrap == BigDecimal.class || wrap == BigInteger.class) {
            return Filters.unwrap(c);
        }
        return Integer.TYPE;
    }

    @Override
    protected Object operate(Object o, Class c) {
        if ((c = Filters.wrap(c)) == Integer.class) {
            return Math.abs(((Number)o).intValue());
        }
        if (c == Float.class) {
            return Float.valueOf(Math.abs(((Number)o).floatValue()));
        }
        if (c == Double.class) {
            return Math.abs(((Number)o).doubleValue());
        }
        if (c == Long.class) {
            return Math.abs(((Number)o).longValue());
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)o).abs();
        }
        if (c == BigInteger.class) {
            return ((BigInteger)o).abs();
        }
        return Math.abs(((Number)o).intValue());
    }
}

