/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.meta.strats.PrimitiveWrapperArrays;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Sized;
import org.apache.openjpa.util.StoreException;

public class CharArrayStreamValueHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 1L;
    private static final CharArrayStreamValueHandler _instance = new CharArrayStreamValueHandler();

    public static CharArrayStreamValueHandler getInstance() {
        return _instance;
    }

    @Override
    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(1005);
        col.setSize(-1);
        return new Column[]{col};
    }

    @Override
    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        if (val == null) {
            return null;
        }
        char[] chars = PrimitiveWrapperArrays.toCharArray(val);
        return new Sized(new CharArrayReader(chars), chars.length);
    }

    @Override
    public Object toObjectValue(ValueMapping vm, Object val) {
        if (val == null) {
            return null;
        }
        Reader reader = (Reader)val;
        CharArrayWriter writer = new CharArrayWriter();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
        }
        catch (IOException ioe) {
            throw new StoreException(ioe);
        }
        return PrimitiveWrapperArrays.toObjectValue(vm, writer.toCharArray());
    }
}

