/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionPeriod;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.List;
import org.hsqldb.lib.Set;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.Type;

public class ExpressionPeriodOp
extends ExpressionLogical {
    PeriodDefinition leftPeriod;
    PeriodDefinition rightPeriod;
    final boolean isSystemVersionCondition;
    boolean transformed;

    private ExpressionPeriodOp(Expression[] expressionArray) {
        super(44);
        this.nodes = expressionArray;
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(int n, Expression expression, Expression expression2) {
        super(n, expression, expression2);
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp() {
        super(60);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        Expression expression = ExpressionPeriodOp.getEpochLimitExpression();
        this.nodes = new Expression[]{expressionPeriod, expression};
        this.isSystemVersionCondition = false;
    }

    ExpressionPeriodOp(Expression expression) {
        super(59);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        this.nodes = new Expression[]{expressionPeriod, expression};
        this.isSystemVersionCondition = true;
    }

    ExpressionPeriodOp(Expression expression, Expression expression2) {
        super(61);
        ExpressionPeriod expressionPeriod = new ExpressionPeriod();
        ExpressionPeriod expressionPeriod2 = new ExpressionPeriod(expression, expression2);
        this.nodes = new Expression[]{expressionPeriod, expressionPeriod2};
        this.isSystemVersionCondition = true;
    }

    boolean isSystemVersionCondition() {
        return this.isSystemVersionCondition;
    }

    void setSystemRangeVariable(Session session, RangeGroup[] rangeGroupArray, RangeVariable rangeVariable) {
        ExpressionPeriod expressionPeriod = (ExpressionPeriod)this.nodes[0];
        expressionPeriod.setRangeVariable(rangeVariable);
        Expression expression = this.nodes[1];
        List<Expression> list = expression.resolveColumnReferences(session, RangeGroup.emptyGroup, rangeGroupArray, null);
        ExpressionColumn.checkColumnsResolved(list);
        expression.resolveTypes(session, null);
        this.transform();
    }

    @Override
    public List<Expression> resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List<Expression> list, boolean bl) {
        ExpressionColumn expressionColumn;
        if (this.opType == 59 && this.nodes[1] instanceof ExpressionPeriod && (expressionColumn = ((ExpressionPeriod)this.nodes[1]).columnExpr) != null) {
            try {
                this.nodes[1].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
            }
            catch (HsqlException hsqlException) {
                this.nodes[1] = expressionColumn;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            list = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, list, bl);
        }
        if (this.nodes[0] instanceof ExpressionPeriod) {
            this.leftPeriod = ((ExpressionPeriod)this.nodes[0]).period;
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            this.rightPeriod = ((ExpressionPeriod)this.nodes[1]).period;
        }
        if (!this.transformed) {
            this.transform();
        }
        return list;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        super.resolveTypes(session, expression);
    }

    private void transform() {
        Expression expression;
        ExpressionPeriod expressionPeriod = (ExpressionPeriod)this.nodes[0];
        boolean bl = true;
        boolean bl2 = true;
        if (expressionPeriod.isNamedPeriod()) {
            if (expressionPeriod.getPeriodType() == 1) {
                // empty if block
            }
            bl = false;
        } else {
            expression = expressionPeriod.getLeftNode();
            if (expression.opType == 8) {
                expression.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            expression = expressionPeriod.getRightNode();
            if (expression.opType == 8) {
                expression.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        if (this.nodes[1] instanceof ExpressionPeriod) {
            expression = (ExpressionPeriod)this.nodes[1];
            if (((ExpressionPeriod)expression).isNamedPeriod()) {
                if (((ExpressionPeriod)expression).getPeriodType() == 1) {
                    // empty if block
                }
                bl2 = false;
            } else {
                Expression expression2 = expression.getLeftNode();
                if (expression2.opType == 8) {
                    expression2.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                expression2 = expression.getRightNode();
                if (expression2.opType == 8) {
                    expression2.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
            }
        } else {
            bl2 = false;
        }
        expression = ExpressionPeriodOp.newExpression(this.opType, this.nodes, bl, bl2);
        this.nodes = expression.nodes;
        this.opType = expression.opType;
        this.transformed = true;
    }

    @Override
    public Object getValue(Session session) {
        Object object = super.getValue(session);
        if (this.opType == 44 && Boolean.FALSE.equals(object)) {
            throw Error.error(3462);
        }
        return object;
    }

    @Override
    void collectObjectNames(Set<HsqlNameManager.HsqlName> set) {
        if (this.leftPeriod != null) {
            set.add(this.leftPeriod.getName());
        }
        if (this.rightPeriod != null) {
            set.add(this.rightPeriod.getName());
        }
    }

    static Expression getEpochLimitExpression() {
        return new ExpressionValue(DateTimeType.epochLimitTimestamp, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
    }

    static ExpressionLogical newExpression(int n, Expression[] expressionArray, boolean bl, boolean bl2) {
        ExpressionLogical expressionLogical;
        ExpressionLogical expressionLogical2;
        ExpressionLogical expressionLogical3;
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        switch (n) {
            case 59: {
                if (expression2 instanceof ExpressionPeriod) {
                    expressionLogical3 = new ExpressionLogical(45, expression.getLeftNode(), expression2.getLeftNode());
                    expressionLogical2 = new ExpressionLogical(41, expression.getRightNode(), expression2.getRightNode());
                } else {
                    expressionLogical3 = new ExpressionLogical(45, expression.getLeftNode(), expression2);
                    expressionLogical2 = new ExpressionLogical(43, expression.getRightNode(), expression2);
                }
                expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                break;
            }
            case 60: {
                if (expression2 instanceof ExpressionPeriod) {
                    expressionLogical3 = new ExpressionLogical(40, expression.getLeftNode(), expression2.getLeftNode());
                    expressionLogical2 = new ExpressionLogical(40, expression.getRightNode(), expression2.getRightNode());
                    expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                    break;
                }
                expressionLogical = new ExpressionLogical(40, expression.getRightNode(), expression2);
                break;
            }
            case 61: {
                expressionLogical3 = new ExpressionLogical(44, expression.getLeftNode(), expression2.getRightNode());
                expressionLogical2 = new ExpressionLogical(43, expression.getRightNode(), expression2.getLeftNode());
                expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
                break;
            }
            case 62: {
                expressionLogical = new ExpressionLogical(45, expression.getRightNode(), expression2.getLeftNode());
                break;
            }
            case 64: {
                expressionLogical = new ExpressionLogical(40, expression.getRightNode(), expression2.getLeftNode());
                break;
            }
            case 63: {
                expressionLogical = new ExpressionLogical(41, expression.getLeftNode(), expression2.getRightNode());
                break;
            }
            case 65: {
                expressionLogical = new ExpressionLogical(40, expression.getLeftNode(), expression2.getRightNode());
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionLogical");
            }
        }
        expressionLogical3 = null;
        expressionLogical2 = null;
        if (bl) {
            expressionLogical3 = new ExpressionPeriodOp(expression.nodes);
        }
        if (bl2) {
            expressionLogical2 = new ExpressionPeriodOp(expression2.nodes);
        }
        if (expressionLogical3 == null) {
            expressionLogical3 = expressionLogical2;
            expressionLogical2 = null;
        }
        if (expressionLogical2 != null) {
            expressionLogical3 = new ExpressionLogical(49, expressionLogical3, expressionLogical2);
            expressionLogical2 = null;
        }
        if (expressionLogical3 != null) {
            expressionLogical = new ExpressionLogical(49, expressionLogical3, expressionLogical);
        }
        return expressionLogical;
    }
}

