/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.util.random.RandomGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.RandomIdentifierParameterSpec;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

@ThreadSafe
public class RandomIdentifierGenerationStrategy
implements IdentifierGenerationStrategy {
    @Nonnull
    private final RandomGenerator random;
    private final int sizeOfIdentifier;
    @Nonnull
    private final BinaryEncoder encoder;

    public RandomIdentifierGenerationStrategy() {
        this.random = new SecureRandom();
        this.sizeOfIdentifier = 16;
        this.encoder = new Hex();
    }

    public RandomIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy.ParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params instanceof RandomIdentifierParameterSpec) {
            RandomIdentifierParameterSpec spec = (RandomIdentifierParameterSpec)params;
            RandomGenerator rng = spec.source();
            this.random = rng != null ? rng : new SecureRandom();
            Integer size = spec.identifierSize();
            if (size != null) {
                if (size <= 0) {
                    throw new InvalidAlgorithmParameterException("Identifier length must be greater than 0");
                }
                this.sizeOfIdentifier = size;
            } else {
                this.sizeOfIdentifier = 16;
            }
            BinaryEncoder enc = spec.identifierEncoder();
            this.encoder = enc != null ? enc : new Hex();
        } else {
            throw new InvalidAlgorithmParameterException("Invalid or unrecognized RandomParameterSpec");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generateIdentifier() {
        return this.generateIdentifier(true);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generateIdentifier(boolean xmlSafe) {
        byte[] buf = new byte[this.sizeOfIdentifier];
        this.random.nextBytes(buf);
        try {
            if (xmlSafe) {
                return "_" + StringUtils.newStringUsAscii((byte[])this.encoder.encode(buf));
            }
            return StringUtils.newStringUsAscii((byte[])this.encoder.encode(buf));
        }
        catch (EncoderException e) {
            throw new RuntimeException(e);
        }
    }
}

