/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.render;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import org.apache.myfaces.core.api.shared.lang.Assert;

public abstract class Renderer<T extends UIComponent> {
    public static final String PASSTHROUGH_RENDERER_LOCALNAME_KEY = "elementName";

    public void decode(FacesContext context, T component) {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
    }

    public void encodeBegin(FacesContext context, T component) throws IOException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
    }

    public void encodeChildren(FacesContext context, T component) throws IOException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        if (((UIComponent)component).getChildCount() > 0) {
            int childCount = ((UIComponent)component).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = ((UIComponent)component).getChildren().get(i);
                if (!child.isRendered()) continue;
                child.encodeAll(context);
            }
        }
    }

    public void encodeEnd(FacesContext context, T component) throws IOException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
    }

    public String convertClientId(FacesContext context, String clientId) {
        Assert.notNull(context, "context");
        Assert.notNull(clientId, "clientId");
        return clientId;
    }

    public boolean getRendersChildren() {
        return false;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        return submittedValue;
    }
}

