/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.token;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;

public class SessionIdGenerator {
    private static Logger log = Logger.getLogger(SessionIdGenerator.class.getName());
    private Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private String jvmRoute = "";
    private int sessionIdLength = 16;

    public void setSecureRandomClass(String secureRandomClass) {
        this.secureRandomClass = secureRandomClass;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public String generateSessionId() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        int resultLenBytes = 0;
        while (resultLenBytes < this.sessionIdLength) {
            this.getRandomBytes(random);
            for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                byte b1 = (byte)((random[j] & 0xF0) >> 4);
                byte b2 = (byte)(random[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
        }
        if (this.jvmRoute != null && this.jvmRoute.length() > 0) {
            buffer.append('.').append(this.jvmRoute);
        }
        return buffer.toString();
    }

    public void getRandomBytes(byte[] bytes) {
        SecureRandom random = this.randoms.poll();
        if (random == null) {
            random = this.createSecureRandom();
        }
        random.nextBytes(bytes);
        this.randoms.add(random);
    }

    private SecureRandom createSecureRandom() {
        SecureRandom result = null;
        long t1 = System.currentTimeMillis();
        if (this.secureRandomClass != null) {
            try {
                Class clazz = ClassUtils.classForName(this.secureRandomClass);
                result = (SecureRandom)clazz.newInstance();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception initializing random number generator of class " + this.secureRandomClass + ". Falling back to java.secure.SecureRandom", e);
            }
        }
        if (result == null) {
            try {
                if (StringUtils.isNotBlank(this.secureRandomProvider)) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                } else if (StringUtils.isNotBlank(this.secureRandomAlgorithm)) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm);
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.log(Level.SEVERE, "Exception initializing random number generator using algorithm: " + this.secureRandomAlgorithm, e);
            }
            catch (NoSuchProviderException e) {
                log.log(Level.SEVERE, "Exception initializing random number generator using provider: " + this.secureRandomProvider, e);
            }
        }
        if (result == null) {
            try {
                result = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.log(Level.SEVERE, "Invalid provider / algoritm SHA1PRNG for generate secure random token", e);
            }
        }
        if (result == null) {
            result = new SecureRandom();
        }
        result.nextInt();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 100L && log.isLoggable(Level.FINEST)) {
            log.info("Creation of SecureRandom instance for session ID generation using [" + result.getAlgorithm() + "] took [" + Long.valueOf(t2 - t1) + "] milliseconds.");
        }
        return result;
    }
}

