/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.impl.DefaultInjectionProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class InjectionProviderFactory {
    private static final String FACTORY_KEY = InjectionProviderFactory.class.getName();

    public static InjectionProviderFactory getInjectionProviderFactory() {
        return InjectionProviderFactory.getInjectionProviderFactory(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static InjectionProviderFactory getInjectionProviderFactory(ExternalContext ctx) {
        Map applicationMap = ctx.getApplicationMap();
        InjectionProviderFactory instance = (InjectionProviderFactory)applicationMap.get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        InjectionProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (InjectionProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, InjectionProviderFactory.class, DefaultInjectionProviderFactory.class));
            } else {
                lpf = (InjectionProviderFactory)SpiUtils.build(ctx, InjectionProviderFactory.class, DefaultInjectionProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            applicationMap.put(FACTORY_KEY, lpf);
        }
        return lpf;
    }

    public static void setInjectionProviderFactory(InjectionProviderFactory instance) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract InjectionProvider getInjectionProvider(ExternalContext var1);

    public abstract void release();
}

