/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.myfaces.resource.ClassLoaderResourceLoaderIterator;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.resource.ResourceMetaImpl;
import org.apache.myfaces.util.lang.ClassUtils;

public class ClassLoaderResourceLoader
extends ResourceLoader {
    public ClassLoaderResourceLoader(String prefix) {
        super(prefix);
    }

    @Override
    public String getLibraryVersion(String path) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        InputStream is = null;
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + "/" + resourceMeta.getResourceIdentifier();
            is = this.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return is;
        }
        is = this.getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        }
        return is;
    }

    public URL getResourceURL(String resourceId) {
        URL url = null;
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + "/" + resourceId;
            url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
        url = this.getClassLoader().getResource(resourceId);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resourceId);
        }
        return url;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        if (resourceMeta == null) {
            return null;
        }
        return this.getResourceURL(resourceMeta.getResourceIdentifier());
    }

    @Override
    public String getResourceVersion(String path) {
        return null;
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    @Override
    public boolean libraryExists(String libraryName) {
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + "/" + libraryName;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            if (url != null) {
                return true;
            }
        } else {
            URL url = this.getClassLoader().getResource(libraryName);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(libraryName);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        Object basePath = path;
        String prefix = this.getPrefix();
        if (prefix != null) {
            basePath = prefix + "/" + (path.startsWith("/") ? path.substring(1) : path);
        }
        URL url = this.getClassLoader().getResource((String)basePath);
        return new ClassLoaderResourceLoaderIterator(url, (String)basePath, maxDepth, options);
    }
}

