/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.w3c.dom.Attr;

public class AuthnStatementUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)parentObject;
        if (childObject instanceof SubjectLocality) {
            authnStatement.setSubjectLocality((SubjectLocality)childObject);
        } else if (childObject instanceof AuthnContext) {
            authnStatement.setAuthnContext((AuthnContext)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("AuthnInstant") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                authnStatement.setAuthnInstant(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else if (attribute.getLocalName().equals("SessionIndex")) {
                authnStatement.setSessionIndex(attribute.getValue());
            } else if (attribute.getLocalName().equals("SessionNotOnOrAfter") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                authnStatement.setSessionNotOnOrAfter(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

