/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.ThreadLocalRandom;

public class RandomJitter
implements Jitter {
    private final long maxJitter;

    public RandomJitter(long maxJitter) {
        this.maxJitter = Preconditions.check(maxJitter, maxJitter > 0L, "Max random jitter must be > 0");
    }

    @Override
    public long generate() {
        return ThreadLocalRandom.current().nextLong(-1L * this.maxJitter, this.maxJitter + 1L);
    }
}

