/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.core.config.Configuration;

public class MapBasedConfiguration
implements Configuration {
    @Nonnull
    private final Map<String, Map<String, Object>> storage = new ConcurrentHashMap<String, Map<String, Object>>();

    @Override
    @Nullable
    public <T> T get(@Nonnull Class<T> configClass, @Nonnull String partitionName) {
        Map<String, Object> partition = this.getPartition(partitionName);
        return configClass.cast(partition.get(configClass.getName()));
    }

    @Override
    public <T, I extends T> void register(@Nonnull Class<T> configClass, @Nonnull I configuration, @Nonnull String partitionName) {
        Map<String, Object> partition = this.getPartition(partitionName);
        partition.put(configClass.getName(), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T deregister(@Nonnull Class<T> configClass, @Nonnull String partitionName) {
        Map<String, Object> partition;
        Map<String, Object> map = partition = this.getPartition(partitionName);
        synchronized (map) {
            T old = configClass.cast(partition.get(configClass.getName()));
            partition.remove(configClass.getName());
            return old;
        }
    }

    @Nonnull
    private synchronized Map<String, Object> getPartition(@Nonnull String partitionName) {
        Map<String, Object> partition = this.storage.get(partitionName);
        if (partition == null) {
            partition = new ConcurrentHashMap<String, Object>();
            this.storage.put(partitionName, partition);
        }
        return partition;
    }
}

