/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedBiConsumer<T, U>
extends AbstractScriptEvaluator
implements BiConsumer<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiConsumer.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiConsumer(@Nonnull @NotEmpty EvaluableScript theScript, @Nullable @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted BiConsumer from " + extraInfo + ":");
    }

    protected ScriptedBiConsumer(@Nonnull @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous BiConsumer:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void accept(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            Class<T> intype1 = types.getFirst();
            Class<U> intype2 = types.getSecond();
            if (null != first && null != intype1 && !intype1.isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), first.getClass(), intype1});
                return;
            }
            if (null != second && null != intype2 && !intype2.isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), second.getClass(), intype2});
                return;
            }
        }
        this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input != null ? input[0] : null, 100);
        scriptContext.setAttribute("input2", input != null ? input[1] : null, 100);
    }

    @Nonnull
    public static <T, U> ScriptedBiConsumer<T, U> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedBiConsumer<T, U> scriptedBiConsumer = new ScriptedBiConsumer<T, U>(script, resource.getDescription());
            return scriptedBiConsumer;
        }
    }

    @Nonnull
    public static <T, U> ScriptedBiConsumer<T, U> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedBiConsumer.resourceScript("JavaScript", resource);
    }

    @Nonnull
    public static <T, U> ScriptedBiConsumer<T, U> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiConsumer<T, U>(script, "Inline");
    }

    @Nonnull
    public static <T, U> ScriptedBiConsumer<T, U> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedBiConsumer<T, U>(script, "Inline");
    }
}

