/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.apache.openejb.resource.jdbc.managed.local.Key;
import org.apache.openejb.resource.jdbc.managed.local.ManagedConnection;
import org.apache.openejb.util.LogCategory;

public class ManagedDataSource
implements DataSource,
Serializable {
    private static final org.apache.openejb.util.Logger LOGGER = org.apache.openejb.util.Logger.getInstance(LogCategory.OPENEJB_RESOURCE_JDBC, ManagedDataSource.class);
    private static final Class<?>[] CONNECTION_CLASS = new Class[]{Connection.class};
    protected final CommonDataSource delegate;
    protected final TransactionManager transactionManager;
    protected final TransactionSynchronizationRegistry registry;
    protected final int hashCode;

    protected ManagedDataSource(CommonDataSource ds, TransactionManager txMgr, TransactionSynchronizationRegistry txRegistry, int hc) {
        this.delegate = ds;
        this.hashCode = hc;
        this.transactionManager = txMgr;
        this.registry = txRegistry;
    }

    public ManagedDataSource(DataSource ds, TransactionManager txMgr, TransactionSynchronizationRegistry txRegistry) {
        this(ds, txMgr, txRegistry, ds.hashCode());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.managed(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.managed(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return DataSource.class.isInstance(this.delegate) ? (T)((DataSource)DataSource.class.cast(this.delegate)).unwrap(iface) : null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataSource.class.isInstance(this.delegate) && ((DataSource)DataSource.class.cast(this.delegate)).isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    private Connection managed(String u, String p) {
        Connection resource = ManagedDataSource.getTxConnection(this.delegate, u, p, this.transactionManager, this.registry);
        if (resource != null) {
            return resource;
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_CLASS, (InvocationHandler)new ManagedConnection(this.delegate, this.transactionManager, this.registry, u, p));
    }

    protected static Connection getTxConnection(CommonDataSource delegate, String u, String p, TransactionManager transactionManager, TransactionSynchronizationRegistry registry) {
        try {
            Object resource;
            Transaction transaction = transactionManager.getTransaction();
            if (transaction != null && ManagedConnection.isUnderTransaction(transaction.getStatus()) && Connection.class.isInstance(resource = registry.getResource((Object)new Key(delegate, u, p)))) {
                return (Connection)Connection.class.cast(resource);
            }
        }
        catch (SystemException e) {
            LOGGER.warning("Attempting to get the current transaction failed with an error: " + e.getMessage(), e);
        }
        return null;
    }

    public CommonDataSource getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        return CommonDataSource.class.isInstance(o) && this.hashCode == o.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    Object writeReplace() throws ObjectStreamException {
        if (Serializable.class.isInstance(this.delegate)) {
            return this.delegate;
        }
        throw new ObjectStreamException(this.delegate + " not serializable"){};
    }
}

