/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationFailure;
import org.apache.openejb.config.ValidationResults;
import org.apache.openejb.config.ValidationWarning;

public class ValidationContext
implements ValidationResults {
    private final List<ValidationFailure> failures = new ArrayList<ValidationFailure>();
    private final List<ValidationWarning> warnings = new ArrayList<ValidationWarning>();
    private final List<ValidationError> errors = new ArrayList<ValidationError>();
    private final String moduleType;
    private final String name;
    private final DeploymentModule module;

    public ValidationContext(Class<? extends DeploymentModule> moduleType, String name) {
        this.moduleType = moduleType.getSimpleName();
        this.name = name;
        this.module = null;
    }

    public ValidationContext(DeploymentModule module) {
        this.moduleType = module.getClass().getSimpleName();
        this.module = module;
        this.name = null;
    }

    public DeploymentModule getModule() {
        return this.module;
    }

    public void fail(String component, String key, Object ... details) {
        ValidationFailure failure = new ValidationFailure(key);
        failure.setDetails(details);
        failure.setComponentName(component);
        this.addFailure(failure);
    }

    public void warn(String component, String key, Object ... details) {
        ValidationWarning warning = new ValidationWarning(key);
        warning.setDetails(details);
        warning.setComponentName(component);
        this.addWarning(warning);
    }

    public void error(String component, String key, Object ... details) {
        ValidationError error = new ValidationError(key);
        error.setDetails(details);
        error.setComponentName(component);
        this.addError(error);
    }

    public void addWarning(ValidationWarning warning) {
        this.warnings.add(warning);
    }

    public void addFailure(ValidationFailure failure) {
        this.failures.add(failure);
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    @Override
    public ValidationFailure[] getFailures() {
        return this.failures.toArray(new ValidationFailure[this.failures.size()]);
    }

    @Override
    public ValidationWarning[] getWarnings() {
        return this.warnings.toArray(new ValidationWarning[this.warnings.size()]);
    }

    @Override
    public ValidationError[] getErrors() {
        return this.errors.toArray(new ValidationError[this.errors.size()]);
    }

    @Override
    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    @Override
    public boolean hasFailures() {
        return this.failures.size() > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    @Override
    public String getName() {
        return this.module == null ? this.name : this.module.getModuleId();
    }

    @Override
    public String getModuleType() {
        return this.moduleType;
    }
}

