/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.jee.wls;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for security-role-assignment complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="security-role-assignment"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="role-name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;choice&gt;
 *           &lt;element name="principal-name" type="{http://www.w3.org/2001/XMLSchema}NMTOKEN" maxOccurs="unbounded"/&gt;
 *           &lt;element name="externally-defined" type="{http://www.bea.com/ns/weblogic/90}empty"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "security-role-assignment", propOrder = {
    "roleName",
    "principalName",
    "externallyDefined"
})
public class SecurityRoleAssignment {

    @XmlElement(name = "role-name", required = true)
    protected String roleName;
    @XmlElementRef(name = "principal-name", namespace = "http://www.bea.com/ns/weblogic/90", type = JAXBElement.class)
    protected List<JAXBElement<String>> principalName;
    @XmlElement(name = "externally-defined")
    protected Empty externallyDefined;
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    /**
     * Gets the value of the roleName property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getRoleName() {
        return roleName;
    }

    /**
     * Sets the value of the roleName property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setRoleName(final String value) {
        this.roleName = value;
    }

    /**
     * Gets the value of the principalName property.
     *
     *
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the principalName property.
     *
     *
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrincipalName().add(newItem);
     * </pre>
     *
     *
     *
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link String }{@code >}
     */
    public List<JAXBElement<String>> getPrincipalName() {
        if (principalName == null) {
            principalName = new ArrayList<JAXBElement<String>>();
        }
        return this.principalName;
    }

    /**
     * Gets the value of the externallyDefined property.
     *
     * @return possible object is
     * {@link Empty }
     */
    public Empty getExternallyDefined() {
        return externallyDefined;
    }

    /**
     * Sets the value of the externallyDefined property.
     *
     * @param value allowed object is
     *              {@link Empty }
     */
    public void setExternallyDefined(final Empty value) {
        this.externallyDefined = value;
    }

    /**
     * Gets the value of the id property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setId(final String value) {
        this.id = value;
    }

}
