/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb;

import org.apache.openejb.loader.SystemInstance;

public class EnvProps {

    public static final String CONFIGURATION = "org/openejb/configuration_source";
    public static final String ASSEMBLER = "org/openejb/assembler_class";
    public static final String CONFIGURATION_FACTORY = "org/openejb/configuration_factory";
    public static final String DEPLOYED_RAR_DIRECTORY = "org/openejb/assembler/rar_directory";
    public static final String DEPLOYED_JAR_DIRECTORY = "org/openejb/assembler/jar_directory";
    public static final String AUTO_CONFIGURE = "openejb.extract.configuration";


    public static boolean extractConfigurationFiles() {
        return SystemInstance.get().getOptions().get(AUTO_CONFIGURE, true);
    }
}
