/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.helpers;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tez.common.Preconditions;

public class SplitsInClientOptionParser {
    private CommandLine cmdLine;
    private String[] otherArgs;
    private boolean parsed = false;

    public String[] getRemainingArgs() {
        Preconditions.checkState((boolean)this.parsed, (Object)"Cannot get remaining args without parsing");
        return (String[])this.otherArgs.clone();
    }

    public boolean parse(String[] args, boolean defaultVal) throws ParseException {
        Preconditions.checkState((!this.parsed ? 1 : 0) != 0, (Object)"Create a new instance for different option sets");
        this.parsed = true;
        Option opt = Option.builder().option("generateSplitsInClient").argName("splits_in_client").hasArg().desc("specify whether splits should be generated in the client").build();
        Options opts = new Options().addOption(opt);
        DefaultParser parser = new DefaultParser();
        this.cmdLine = parser.parse(opts, args, false);
        if (this.cmdLine.hasOption("generateSplitsInClient")) {
            defaultVal = Boolean.parseBoolean(this.cmdLine.getOptionValue("generateSplitsInClient"));
        }
        this.otherArgs = this.cmdLine.getArgs();
        return defaultVal;
    }
}

