/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class TezExampleBase
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(TezExampleBase.class);
    private TezClient tezClientInternal;
    protected static final String DISABLE_SPLIT_GROUPING = "disableSplitGrouping";
    protected static final String LOCAL_MODE = "local";
    protected static final String COUNTER_LOG = "counter";
    protected static final String GENERATE_SPLIT_IN_CLIENT = "generateSplitInClient";
    protected static final String LEAVE_AM_RUNNING = "leaveAmRunning";
    protected static final String RECONNECT_APP_ID = "reconnectAppId";
    private boolean disableSplitGrouping = false;
    private boolean isLocalMode = false;
    private boolean isCountersLog = false;
    private boolean generateSplitInClient = false;
    private boolean leaveAmRunning = false;
    private String reconnectAppId;
    private HadoopShim hadoopShim;

    protected boolean isCountersLog() {
        return this.isCountersLog;
    }

    protected boolean isDisableSplitGrouping() {
        return this.disableSplitGrouping;
    }

    protected boolean isGenerateSplitInClient() {
        return this.generateSplitInClient;
    }

    private Options getExtraOptions() {
        Options options = new Options();
        options.addOption(LOCAL_MODE, false, "run it as local mode");
        options.addOption(DISABLE_SPLIT_GROUPING, false, "disable split grouping");
        options.addOption(COUNTER_LOG, false, "print counter log");
        options.addOption(GENERATE_SPLIT_IN_CLIENT, false, "whether generate split in client");
        options.addOption(LEAVE_AM_RUNNING, false, "whether client should stop session");
        options.addOption(RECONNECT_APP_ID, true, "appId for client reconnect");
        return options;
    }

    public final int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        GenericOptionsParser optionParser = new GenericOptionsParser(conf, this.getExtraOptions(), args);
        String[] otherArgs = optionParser.getRemainingArgs();
        if (optionParser.getCommandLine().hasOption(LOCAL_MODE)) {
            this.isLocalMode = true;
        }
        if (optionParser.getCommandLine().hasOption(DISABLE_SPLIT_GROUPING)) {
            this.disableSplitGrouping = true;
        }
        if (optionParser.getCommandLine().hasOption(COUNTER_LOG)) {
            this.isCountersLog = true;
        }
        if (optionParser.getCommandLine().hasOption(GENERATE_SPLIT_IN_CLIENT)) {
            this.generateSplitInClient = true;
        }
        if (optionParser.getCommandLine().hasOption(LEAVE_AM_RUNNING)) {
            this.leaveAmRunning = true;
        }
        if (optionParser.getCommandLine().hasOption(RECONNECT_APP_ID)) {
            this.reconnectAppId = optionParser.getCommandLine().getOptionValue(RECONNECT_APP_ID);
        }
        this.hadoopShim = new HadoopShimsLoader(conf).getHadoopShim();
        return this._execute(otherArgs, null, null);
    }

    public int run(TezConfiguration conf, String[] args, @Nullable TezClient tezClient) throws Exception {
        this.setConf((Configuration)conf);
        this.hadoopShim = new HadoopShimsLoader((Configuration)conf).getHadoopShim();
        GenericOptionsParser optionParser = new GenericOptionsParser((Configuration)conf, this.getExtraOptions(), args);
        if (optionParser.getCommandLine().hasOption(LOCAL_MODE)) {
            this.isLocalMode = true;
            if (tezClient != null) {
                throw new RuntimeException("can't specify local mode when TezClient is created, it takes no effect");
            }
        }
        if (optionParser.getCommandLine().hasOption(DISABLE_SPLIT_GROUPING)) {
            this.disableSplitGrouping = true;
        }
        if (optionParser.getCommandLine().hasOption(COUNTER_LOG)) {
            this.isCountersLog = true;
        }
        if (optionParser.getCommandLine().hasOption(GENERATE_SPLIT_IN_CLIENT)) {
            this.generateSplitInClient = true;
        }
        String[] otherArgs = optionParser.getRemainingArgs();
        return this._execute(otherArgs, conf, tezClient);
    }

    public int runDag(DAG dag, boolean printCounters, Logger logger) throws TezException, InterruptedException, IOException {
        DAGStatus dagStatus;
        this.tezClientInternal.waitTillReady();
        CallerContext callerContext = CallerContext.create((String)"TezExamples", (String)("Tez Example DAG: " + dag.getName()));
        ApplicationId appId = this.tezClientInternal.getAppMasterApplicationId();
        if (this.hadoopShim == null) {
            Configuration conf = this.getConf() == null ? new Configuration(false) : this.getConf();
            this.hadoopShim = new HadoopShimsLoader(conf).getHadoopShim();
        }
        if (appId != null) {
            TezUtilsInternal.setHadoopCallerContext((HadoopShim)this.hadoopShim, (ApplicationId)appId);
            callerContext.setCallerIdAndType(appId.toString(), "TezExampleApplication");
        }
        dag.setCallerContext(callerContext);
        DAGClient dagClient = this.tezClientInternal.submitDAG(dag);
        HashSet getOpts = Sets.newHashSet();
        if (printCounters) {
            getOpts.add(StatusGetOpts.GET_COUNTERS);
        }
        if ((dagStatus = dagClient.waitForCompletionWithStatusUpdates((Set)getOpts)).getState() != DAGStatus.State.SUCCEEDED) {
            logger.info("DAG diagnostics: " + dagStatus.getDiagnostics());
            return -1;
        }
        return 0;
    }

    private int _validateArgs(String[] args) {
        int res = this.validateArgs(args);
        if (res != 0) {
            this._printUsage();
            return res;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _execute(String[] otherArgs, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        int result = this._validateArgs(otherArgs);
        if (result != 0) {
            return result;
        }
        if (tezConf == null) {
            tezConf = new TezConfiguration(this.getConf());
        }
        if (this.isLocalMode) {
            LOG.info("Running in local mode...");
            tezConf.setBoolean("tez.local.mode", true);
            tezConf.set("fs.defaultFS", "file:///");
            tezConf.setBoolean("tez.runtime.optimize.local.fetch", true);
        }
        UserGroupInformation.setConfiguration((Configuration)tezConf);
        boolean ownTezClient = false;
        if (tezClient == null) {
            ownTezClient = true;
            this.tezClientInternal = this.createTezClient(tezConf);
        } else {
            this.tezClientInternal = tezClient;
        }
        try {
            int n = this.runJob(otherArgs, tezConf, this.tezClientInternal);
            return n;
        }
        finally {
            if (ownTezClient && this.tezClientInternal != null && !this.leaveAmRunning) {
                this.tezClientInternal.stop();
            }
        }
    }

    private TezClient createTezClient(TezConfiguration tezConf) throws IOException, TezException {
        TezClient tezClient = TezClient.create((String)"TezExampleApplication", (TezConfiguration)tezConf);
        if (this.reconnectAppId != null) {
            ApplicationId appId = TezClient.appIdfromString((String)this.reconnectAppId);
            tezClient.getClient(appId);
        } else {
            tezClient.start();
        }
        return tezClient;
    }

    private void _printUsage() {
        this.printUsage();
        System.err.println();
        this.printExtraOptionsUsage(System.err);
        System.err.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected abstract void printUsage();

    protected void printExtraOptionsUsage(PrintStream ps) {
        ps.println("Tez example extra options supported are");
        ps.println("-local\t\trun it in tez local mode,  run it in distributed mode without this option");
        ps.println("-disableSplitGrouping\t\t disable split grouping for MRInput, enable split grouping without this option.");
        ps.println("-counter\t\t to print counters information");
        ps.println("-generateSplitInClient\t\tgenerate input split in client");
        ps.println("-leaveAmRunning\t\twhether client should stop session");
        ps.println("-reconnectAppId\t\tappId for client reconnect");
        ps.println();
        ps.println("The Tez example extra options usage syntax is ");
        ps.println("example_name [extra_options] [example_parameters]");
    }

    protected abstract int validateArgs(String[] var1);

    protected abstract int runJob(String[] var1, TezConfiguration var2, TezClient var3) throws Exception;

    @InterfaceAudience.Private
    @VisibleForTesting
    public ApplicationId getAppId() {
        if (this.tezClientInternal == null) {
            LOG.warn("TezClient is not initialized, return null for AppId");
            return null;
        }
        return this.tezClientInternal.getAppMasterApplicationId();
    }
}

