/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.fs.LfsOperator$;
import org.apache.streampark.common.util.FileUtils$;
import org.apache.streampark.common.util.HostsUtils$;
import org.apache.streampark.common.util.PropertiesUtils$;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HadoopConfigUtils$ {
    public static HadoopConfigUtils$ MODULE$;
    private scala.collection.immutable.Map<String, String> kerberosConf;
    private String hadoopUserName;
    private String kerberosDebug;
    private boolean kerberosEnable;
    private String kerberosPrincipal;
    private final String kerberosKeytab;
    private final String kerberosKrb5;
    private final String[] HADOOP_CLIENT_CONF_FILES;
    private final String[] HIVE_CLIENT_CONF_FILES;
    private volatile byte bitmap$0;

    static {
        new HadoopConfigUtils$();
    }

    private scala.collection.immutable.Map<String, String> kerberosConf$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String appHome;
                File file;
                scala.collection.immutable.Map map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap(System.getProperties()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopConfigUtils$.$anonfun$kerberosConf$1(x$1)))).toMap(Predef$.MODULE$.$conforms());
                scala.collection.immutable.Map map2 = map;
                Object object = map2.nonEmpty() ? map2 : ((file = new File(new StringBuilder(18).append(appHome = SystemPropertyUtils$.MODULE$.get(ConfigConst$.MODULE$.KEY_APP_HOME(), null)).append("/conf/kerberos.yml").toString())).exists() && file.isFile() ? PropertiesUtils$.MODULE$.fromYamlFile(file.getAbsolutePath()) : Predef$.MODULE$.Map().empty());
                this.kerberosConf = object;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.kerberosConf;
    }

    private scala.collection.immutable.Map<String, String> kerberosConf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.kerberosConf$lzycompute() : this.kerberosConf;
    }

    private String hadoopUserName$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopUserName = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_HADOOP_USER_NAME());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopUserName;
    }

    public String hadoopUserName() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hadoopUserName$lzycompute() : this.hadoopUserName;
    }

    private String kerberosDebug$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.kerberosDebug = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_DEBUG(), (Function0 & Serializable & scala.Serializable)() -> "false");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.kerberosDebug;
    }

    public String kerberosDebug() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.kerberosDebug$lzycompute() : this.kerberosDebug;
    }

    private boolean kerberosEnable$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.kerberosEnable = new StringOps(Predef$.MODULE$.augmentString((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_ENABLE(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.kerberosEnable;
    }

    public boolean kerberosEnable() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.kerberosEnable$lzycompute() : this.kerberosEnable;
    }

    private String kerberosPrincipal$lzycompute() {
        HadoopConfigUtils$ hadoopConfigUtils$ = this;
        synchronized (hadoopConfigUtils$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.kerberosPrincipal = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_PRINCIPAL(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.kerberosPrincipal;
    }

    public String kerberosPrincipal() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.kerberosPrincipal$lzycompute() : this.kerberosPrincipal;
    }

    public String kerberosKeytab() {
        return this.kerberosKeytab;
    }

    public String kerberosKrb5() {
        return this.kerberosKrb5;
    }

    private String[] HADOOP_CLIENT_CONF_FILES() {
        return this.HADOOP_CLIENT_CONF_FILES;
    }

    private String[] HIVE_CLIENT_CONF_FILES() {
        return this.HIVE_CLIENT_CONF_FILES;
    }

    public Option<String> getSystemHadoopConfDir() {
        Some some;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileUtils$.MODULE$.getPathFromEnv("HADOOP_CONF_DIR"));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String p = (String)success.value();
            some = new Some((Object)p);
        } else if (try_ instanceof Failure) {
            String p = FileUtils$.MODULE$.resolvePath(FileUtils$.MODULE$.getPathFromEnv("HADOOP_HOME"), "/etc/hadoop");
            some = new Some((Object)p);
        } else {
            throw new MatchError((Object)try_);
        }
        return some;
    }

    public Optional<String> getSystemHadoopConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHadoopConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public Option<String> getSystemHiveConfDir() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileUtils$.MODULE$.getPathFromEnv("HIVE_CONF_DIR")).toOption();
    }

    public Optional<String> getSystemHiveConfDirAsJava() {
        return Optional.ofNullable(this.getSystemHiveConfDir().orNull(Predef$.MODULE$.$conforms()));
    }

    public void replaceHostWithIP(File configFile) {
        block0: {
            ListMap<String, String> hostsMap;
            if (!configFile.exists() || !configFile.isFile() || !configFile.getName().endsWith(".xml") || !(hostsMap = HostsUtils$.MODULE$.getSortSystemHosts()).nonEmpty()) break block0;
            this.rewriteHostIpMapper(configFile, hostsMap);
        }
    }

    public void batchReplaceHostWithIP(File configDir, String[] filter) {
        if (!configDir.isDirectory()) {
            this.replaceHostWithIP(configDir);
            return;
        }
        ListMap<String, String> hostsMap = HostsUtils$.MODULE$.getSortSystemHosts();
        if (hostsMap.isEmpty()) {
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configDir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFile())))).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)HadoopConfigUtils$.$anonfun$batchReplaceHostWithIP$2(filter, e))))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            HadoopConfigUtils$.MODULE$.rewriteHostIpMapper(x$3, (ListMap<String, String>)hostsMap);
            return BoxedUnit.UNIT;
        });
    }

    public String[] batchReplaceHostWithIP$default$2() {
        return this.HADOOP_CLIENT_CONF_FILES();
    }

    private void rewriteHostIpMapper(File configFile, ListMap<String, String> hostsMap) {
        Buffer lines = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(FileUtils.readLines((File)configFile)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String string2 = x0$1;
            if (!string2.trim().startsWith("<value>")) {
                string = string2;
            } else {
                Option shot = hostsMap.find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)string2.contains((CharSequence)e._1())));
                ObjectRef li = ObjectRef.create((Object)string2);
                while (shot.nonEmpty()) {
                    li.elem = ((String)li.elem).replace((CharSequence)((Tuple2)shot.get())._1(), (CharSequence)((Tuple2)shot.get())._2());
                    shot = hostsMap.find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)HadoopConfigUtils$.$anonfun$rewriteHostIpMapper$3(li, e)));
                }
                string = (String)li.elem;
            }
            return string;
        }, Buffer$.MODULE$.canBuildFrom());
        FileUtils.writeLines((File)configFile, (Collection)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(lines));
    }

    public java.util.Map<String, String> readSystemHadoopConf() {
        return (java.util.Map)this.getSystemHadoopConfDir().map((Function1 & Serializable & scala.Serializable)confDir -> (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir((String)confDir))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HadoopConfigUtils$.$anonfun$readSystemHadoopConf$2(f))))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).asJava()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap());
    }

    public java.util.Map<String, String> readSystemHiveConf() {
        return (java.util.Map)this.getSystemHiveConfDir().map((Function1 & Serializable & scala.Serializable)confDir -> (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LfsOperator$.MODULE$.listDir((String)confDir))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HadoopConfigUtils$.$anonfun$readSystemHiveConf$2(f))))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), (Object)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).asJava()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap());
    }

    public static final /* synthetic */ boolean $anonfun$kerberosConf$1(Tuple2 x$1) {
        return ((String)x$1._1()).startsWith("security.kerberos");
    }

    public static final /* synthetic */ boolean $anonfun$batchReplaceHostWithIP$2(String[] filter$1, File e) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filter$1)).contains((Object)e.getName());
    }

    public static final /* synthetic */ boolean $anonfun$rewriteHostIpMapper$3(ObjectRef li$1, Tuple2 e) {
        return ((String)li$1.elem).contains((CharSequence)e._1());
    }

    public static final /* synthetic */ boolean $anonfun$readSystemHadoopConf$2(File f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.HADOOP_CLIENT_CONF_FILES())).contains((Object)f.getName());
    }

    public static final /* synthetic */ boolean $anonfun$readSystemHiveConf$2(File f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.HIVE_CLIENT_CONF_FILES())).contains((Object)f.getName());
    }

    private HadoopConfigUtils$() {
        MODULE$ = this;
        this.kerberosKeytab = ((String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KEYTAB(), (Function0 & Serializable & scala.Serializable)() -> "")).trim();
        this.kerberosKrb5 = (String)this.kerberosConf().getOrElse((Object)ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KRB5_CONF(), (Function0 & Serializable & scala.Serializable)() -> "");
        this.HADOOP_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "yarn-site.xml"});
        this.HIVE_CLIENT_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "hive-site.xml"});
    }
}

